/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.block;

import geni.witherutilsexp.api.common.tile.BaseTile;
import geni.witherutilsexp.api.common.util.UtilTileEntity;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BaseFluidTileSync
extends BaseTile {
    protected FluidTank tank = new FluidTank(1000);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public BaseFluidTileSync(@Nonnull TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public BaseFluidTileSync(@Nonnull TileEntityType<?> tileEntityTypeIn, int capacity) {
        super(tileEntityTypeIn);
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                BaseFluidTileSync.this.syncFluidToClient();
            }
        };
    }

    public BaseFluidTileSync(@Nonnull TileEntityType<?> tileEntityTypeIn, int capacity, Predicate<FluidStack> validator) {
        super(tileEntityTypeIn);
        this.tank = new FluidTank(capacity, validator){

            protected void onContentsChanged() {
                BaseFluidTileSync.this.syncFluidToClient();
            }
        };
    }

    public void syncFluidToClient() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CompoundNBT compound = new CompoundNBT();
            super.func_189515_b(compound);
            UtilTileEntity.sendUpdatePacket((TileEntity)this, compound);
        }
    }

    public void syncFluidToPlayer(ServerPlayerEntity player) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CompoundNBT compound = new CompoundNBT();
            super.func_189515_b(compound);
            UtilTileEntity.sendUpdatePacket((TileEntity)this, compound);
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

