/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.block;

import geni.witherutilsexp.api.common.block.ISyncableObject;
import geni.witherutilsexp.api.common.liquids.GenericTank;
import geni.witherutilsexp.api.common.util.IValueProvider;
import java.io.IOException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankSyncable
extends GenericTank
implements ISyncableObject,
IValueProvider<FluidStack> {
    private boolean dirty = false;

    public TankSyncable() {
        super(0);
    }

    public TankSyncable(int capacity) {
        super(capacity);
    }

    public TankSyncable(int capacity, Fluid ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    public TankSyncable(int capacity, FluidStack ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    public TankSyncable(int capacity, Predicate<FluidStack> validator) {
        super(capacity);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void readFromStream(PacketBuffer stream) throws IOException {
        this.fluid = FluidStack.readFromPacket((PacketBuffer)stream);
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        this.fluid.writeToPacket(stream);
    }

    @Override
    public void writeToNBT(CompoundNBT tag, String name) {
        CompoundNBT tankTag = new CompoundNBT();
        this.writeToNBT(tankTag);
        tag.func_218657_a(name, (INBT)tankTag);
    }

    @Override
    public void readFromNBT(CompoundNBT tag, String name) {
        if (tag.func_150297_b(name, 10)) {
            CompoundNBT tankTag = tag.func_74775_l(name);
            this.readFromNBT(tankTag);
        } else {
            this.readFromNBT(tag);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = super.fill(resource, action);
        if (action.execute() && filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(stack, action);
        if (action.execute() && !drained.isEmpty()) {
            this.markDirty();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (action.execute() && !drained.isEmpty()) {
            this.markDirty();
        }
        return drained;
    }

    @Override
    public FluidStack getValue() {
        return super.getFluid().copy();
    }

    public void setFluid(@Nullable FluidStack fluid) {
        super.setFluid(fluid);
        this.markDirty();
    }
}

