/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.item;

import geni.witherutilsexp.api.common.util.UtilItemStack;
import geni.witherutilsexp.registry.ItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseItem
extends Item {
    public static final float INACCURACY_DEFAULT = 1.0f;
    public static final float VELOCITY_MAX = 1.5f;

    public BaseItem(Item.Properties properties) {
        super(properties);
        ItemRegistry.items.add(this);
    }

    protected void shootMe(World world, PlayerEntity shooter, ProjectileItemEntity ball) {
        this.shootMe(world, shooter, ball, 0.0f);
    }

    protected void shootMe(World world, PlayerEntity shooter, ProjectileItemEntity ball, float pitch) {
        if (world.field_72995_K) {
            return;
        }
        Vector3d vector3d1 = shooter.func_213286_i(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), pitch, true);
        Vector3d vector3d = shooter.func_70676_i(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.func_214905_a(quaternion);
        ball.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 2.25f, 1.0f);
        world.func_217376_c((Entity)ball);
    }

    protected ItemStack findAmmo(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack.func_77973_b() != item) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void tryRepairWith(ItemStack stackToRepair, PlayerEntity player, Item target) {
        ItemStack torches;
        if (stackToRepair.func_77951_h() && !(torches = this.findAmmo(player, target)).func_190926_b()) {
            torches.func_190918_g(1);
            UtilItemStack.repairItem(stackToRepair);
        }
    }

    public float getChargedPercent(ItemStack stack, int chargeTimer) {
        return BowItem.func_185059_b((int)(this.func_77626_a(stack) - chargeTimer));
    }

    protected BaseItem setHasEnergy() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent a = new TranslationTextComponent("Information/About:                ");
        a.func_240699_a_(TextFormatting.GOLD);
        TranslationTextComponent b = new TranslationTextComponent("");
        b.func_240699_a_(TextFormatting.GOLD);
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.WHITE});
        tooltip.add((ITextComponent)b);
        tooltip.add((ITextComponent)a);
        tooltip.add((ITextComponent)b);
        tooltip.add((ITextComponent)t);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }
}

