/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.liquids;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import geni.witherutilsexp.api.common.util.UtilBlock;
import geni.witherutilsexp.api.common.util.UtilCollection;
import geni.witherutilsexp.api.common.util.UtilCompatibility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GenericTank
extends FluidTank {
    private List<Direction> surroundingTanks = Lists.newArrayList();
    private final IFluidFilter filter;
    private static final IFluidFilter NO_RESTRICTIONS = stack -> true;

    private static IFluidFilter filter(FluidStack ... acceptableFluids) {
        if (acceptableFluids.length == 0) {
            return NO_RESTRICTIONS;
        }
        return stack -> {
            for (FluidStack acceptableFluid : acceptableFluids) {
                if (!acceptableFluid.isFluidEqual(stack)) continue;
                return true;
            }
            return false;
        };
    }

    public GenericTank(int capacity) {
        super(capacity);
        this.filter = NO_RESTRICTIONS;
    }

    public GenericTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(acceptableFluids);
    }

    public GenericTank(int capacity, Fluid ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(UtilCollection.transform(FluidStack.class, acceptableFluids, input -> new FluidStack(input, 0)));
    }

    private static boolean isNeighbourTank(World world, BlockPos coord, Direction dir) {
        TileEntity tile = UtilBlock.getTileInDirectionSafe(world, coord, dir);
        return UtilCompatibility.isFluidHandler(tile, dir.func_176734_d());
    }

    private static Set<Direction> getSurroundingTanks(World world, BlockPos coord) {
        EnumSet<Direction> result = EnumSet.noneOf(Direction.class);
        for (Direction dir : Direction.values()) {
            if (!GenericTank.isNeighbourTank(world, coord, dir)) continue;
            result.add(dir);
        }
        return result;
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public boolean isFluidValid(FluidStack fluid) {
        return this.filter.canAcceptFluid(fluid);
    }

    public void updateNeighbours(World world, BlockPos coord, Set<Direction> sides) {
        this.surroundingTanks = Lists.newArrayList((Iterable)Sets.difference(GenericTank.getSurroundingTanks(world, coord), sides));
    }

    public void updateNeighbours(World world, BlockPos coord) {
        this.surroundingTanks = Lists.newArrayList(GenericTank.getSurroundingTanks(world, coord));
    }

    private static int tryFillNeighbour(FluidStack drainedFluid, Direction side, TileEntity otherTank) {
        FluidStack toFill = drainedFluid.copy();
        Direction fillSide = side.func_176734_d();
        IFluidHandler fluidHandler = UtilCompatibility.getFluidHandler(otherTank, fillSide);
        return fluidHandler != null ? fluidHandler.fill(toFill, IFluidHandler.FluidAction.EXECUTE) : 0;
    }

    public void distributeToSides(int amount, World world, BlockPos coord, Set<Direction> allowedSides) {
        FluidStack drainedFluid;
        if (world == null) {
            return;
        }
        if (this.getFluidAmount() <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        if ((drainedFluid = this.drain(amount, IFluidHandler.FluidAction.SIMULATE)).getAmount() > 0) {
            int distributed;
            int startingAmount = drainedFluid.getAmount();
            Collections.shuffle(sides);
            for (Direction side : this.surroundingTanks) {
                if (drainedFluid.getAmount() <= 0) break;
                TileEntity otherTank = UtilBlock.getTileInDirection(world, coord, side);
                if (otherTank == null) continue;
                drainedFluid.shrink(GenericTank.tryFillNeighbour(drainedFluid, side, otherTank));
            }
            if ((distributed = startingAmount - drainedFluid.getAmount()) > 0) {
                this.drain(distributed, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public void fillFromSides(int maxAmount, World world, BlockPos coord) {
        this.fillFromSides(maxAmount, world, coord, null);
    }

    public void fillFromSides(int maxAmount, World world, BlockPos coord, Set<Direction> allowedSides) {
        if (world == null) {
            return;
        }
        int toDrain = Math.min(maxAmount, this.getSpace());
        if (toDrain <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        Collections.shuffle(sides);
        for (Direction side : sides) {
            if (toDrain <= 0) break;
            toDrain -= this.fillInternal(world, coord, side, toDrain);
        }
    }

    public int fillFromSide(World world, BlockPos coord, Direction side) {
        int maxDrain = this.getSpace();
        if (maxDrain <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    public int fillFromSide(int maxDrain, World world, BlockPos coord, Direction side) {
        if ((maxDrain = Math.min(maxDrain, this.getSpace())) <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    private int fillInternal(World world, BlockPos coord, Direction side, int maxDrain) {
        int filled;
        FluidStack drained;
        Direction drainSide;
        TileEntity otherTank = UtilBlock.getTileInDirection(world, coord, side);
        IFluidHandler handler = UtilCompatibility.getFluidHandler(otherTank, drainSide = side.func_176734_d());
        if (handler != null && (drained = handler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && this.filter.canAcceptFluid(drained) && (filled = this.fill(drained, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            handler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            return filled;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface IFluidFilter {
        public boolean canAcceptFluid(FluidStack var1);
    }
}

