/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.network;

import geni.witherutilsexp.api.common.network.BasePacket;
import geni.witherutilsexp.api.common.tile.BaseTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFluidSync
extends BasePacket {
    private BlockPos pos;
    private FluidStack fluid;

    public PacketFluidSync(BlockPos p, FluidStack fluid) {
        this.pos = p;
        this.fluid = fluid;
    }

    public static void handle(PacketFluidSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketFluidSync.doWork(message));
        message.done(ctx);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void doWork(PacketFluidSync message) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        TileEntity te = world.func_175625_s(message.pos);
        if (te instanceof BaseTile) {
            ((BaseTile)te).setFluid(message.fluid);
        }
    }

    public static PacketFluidSync decode(PacketBuffer buf) {
        PacketFluidSync msg = new PacketFluidSync(buf.func_179259_c(), FluidStack.loadFluidStackFromNBT((CompoundNBT)buf.func_150793_b()));
        return msg;
    }

    public static void encode(PacketFluidSync msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        CompoundNBT tags = new CompoundNBT();
        if (msg.fluid != null) {
            msg.fluid.writeToNBT(tags);
        }
        buf.func_150786_a(tags);
    }
}

