/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.tile;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseTile
extends TileEntity
implements IInventory {
    public static final String NBTINV = "inv";
    public static final String NBTENERGY = "energy";
    public static final String NBTFLUID = "fluid";
    public static final int MENERGY = 64000;
    protected int needsRedstone = 1;
    protected int cooktimer;
    public boolean isRedstonePowered;

    public BaseTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public float power() {
        Direction direction = (Direction)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208157_J);
        return (float)this.field_145850_b.func_175651_c(this.field_174879_c, direction) / 15.0f;
    }

    public int isTimedby() {
        return this.cooktimer;
    }

    public void setLitProperty(boolean lit) {
    }

    public Direction getCurrentFacing() {
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        return null;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return syncData;
    }

    protected BlockPos getCurrentFacingPos(int distance) {
        Direction f = this.getCurrentFacing();
        if (f != null) {
            return this.field_174879_c.func_177967_a(f, distance);
        }
        return this.field_174879_c;
    }

    protected BlockPos getCurrentFacingPos() {
        return this.getCurrentFacingPos(1);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean isPowered() {
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    public boolean requiresRedstone() {
        return this.needsRedstone == 1;
    }

    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.needsRedstone = tag.func_74762_e("needsRedstone");
        this.cooktimer = tag.func_74762_e("cooktimer");
        super.func_230337_a_(bs, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("needsRedstone", this.needsRedstone);
        tag.func_74768_a("cooktimer", this.cooktimer);
        return super.func_189515_b(tag);
    }

    public void setNeedsRedstone(int value) {
        this.needsRedstone = value % 2;
    }

    public void setRedstonePowered(boolean powered) {
        this.isRedstonePowered = powered;
        this.func_70296_d();
    }

    public void setFluid(FluidStack fluid) {
    }

    @Deprecated
    public int func_70302_i_() {
        return 0;
    }

    @Deprecated
    public boolean func_191420_l() {
        return true;
    }

    @Deprecated
    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_70299_a(int index, ItemStack stack) {
    }

    @Deprecated
    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    @Deprecated
    public void func_174888_l() {
    }

    public abstract void setField(int var1, int var2);

    public abstract int getField(int var1);

    public void setFieldString(int field, String value) {
    }

    public String getFieldString(int field) {
        return null;
    }

    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public boolean moveItems(Direction myFacingDir, int max, IItemHandler handlerHere) {
        if (this.field_145850_b.func_201670_d()) {
            return false;
        }
        if (handlerHere == null) {
            return false;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IItemHandler handlerOutput = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        if (handlerHere != null && handlerOutput != null) {
            int sizeAfter;
            int theslot = 0;
            ItemStack drain = handlerHere.getStackInSlot(theslot).func_77946_l();
            int sizeStarted = drain.func_190916_E();
            if (!drain.func_190926_b()) {
                for (int slot = 0; slot < handlerOutput.getSlots() && !(drain = handlerOutput.insertItem(slot, drain, false)).func_190926_b(); ++slot) {
                }
            }
            if ((sizeAfter = sizeStarted - drain.func_190916_E()) > 0) {
                handlerHere.extractItem(theslot, sizeAfter, false);
            }
            return true;
        }
        return false;
    }

    public IInventory getInventory() {
        return this.getInventory();
    }

    public IEnergyStorage getEnergyStorage(Direction facing) {
        return null;
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public int getX() {
        return this.func_174877_v().func_177958_n();
    }

    public int getY() {
        return this.func_174877_v().func_177956_o();
    }

    public int getZ() {
        return this.func_174877_v().func_177952_p();
    }

    public World getWorldObject() {
        return this.func_145831_w();
    }

    @Nullable
    public ResourceLocation getSound() {
        return null;
    }

    public boolean hasSound() {
        return this.getSound() != null;
    }

    public float getVolume() {
        return 1.0f;
    }

    public float getPitch() {
        return 1.0f;
    }

    protected boolean shouldPlaySound() {
        return this.isPowered();
    }
}

