/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registry<T extends IForgeRegistryEntry<T>> {
    private final LinkedHashMap<ResourceLocation, List<T>> objects;
    private final Class<T> clazz;
    private final String id;
    private boolean frozen;

    public Registry(Class<T> clazz, String id) {
        this(clazz, new LinkedHashMap<ResourceLocation, List<T>>(), id);
    }

    public Registry(Class<T> clazz, Registry<T> registry, String id) {
        this(clazz, registry.objects, id);
    }

    public Registry(Class<T> clazz, LinkedHashMap<ResourceLocation, List<T>> objects, String id) {
        this.clazz = clazz;
        this.id = id;
        this.objects = new LinkedHashMap<ResourceLocation, List<T>>(objects);
    }

    public <E extends Entity> EntityType<E> register(String name, EntityType.IFactory<E> factory, EntityClassification classification, float width, float height, int updateInterval, int range, boolean sendVelocity) {
        EntityType entityType = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification).func_220321_a(width, height).setUpdateInterval(updateInterval).setTrackingRange(range).setShouldReceiveVelocityUpdates(sendVelocity).func_206830_a(name);
        this.register(name, entityType);
        return entityType;
    }

    public <E extends TileEntity> TileEntityType<E> register(String name, Supplier<? extends E> factory, Block ... blocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null);
        this.register(name, type);
        return type;
    }

    public <O extends T> O register(String name, O o) {
        return this.register(name, o, true);
    }

    private <O extends T> O register(String name, O o, boolean flag) {
        o.setRegistryName(new ResourceLocation(this.id, name));
        if (flag) {
            this.objects.put(o.getRegistryName(), Lists.newArrayList((Object[])new IForgeRegistryEntry[]{o}));
        }
        return o;
    }

    public List<T> getSiblings(String name) {
        return this.getSiblings(new ResourceLocation(this.id, name));
    }

    public List<T> getSiblings(ResourceLocation key) {
        return this.objects.getOrDefault(key, new ArrayList());
    }

    public void init() {
        if (this.frozen) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(this.clazz, this::registerAll);
        this.frozen = true;
    }

    public void registerAll(RegistryEvent.Register<T> event) {
        this.forEach(t -> event.getRegistry().register(t));
    }

    public Registry<Item> getBlockItems(@Nullable ItemGroup group) {
        Registry<Item> reg = new Registry<Item>(Item.class, this.id);
        this.forEach(object -> {
            if (object instanceof Block) {
                Block block = (Block)object;
                ResourceLocation resourceLocation = block.getRegistryName();
            }
        });
        return reg;
    }

    public void forEach(Consumer<T> action) {
        this.objects.forEach((? super K rl, ? super V ts) -> ts.forEach(action));
    }

    public LinkedHashMap<ResourceLocation, List<T>> getObjects() {
        return this.objects;
    }

    public String getId() {
        return this.id;
    }
}

