/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Orientation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class UtilBlock {
    public static boolean isBlockInOrAdjacentMaterial(World world, BlockPos blockPos, Material material) {
        for (BlockPos position : UtilBlock.getAdjacentBlocks(blockPos)) {
            if (!UtilBlock.isBlockGivenMaterial(world, position, material)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos[] getAdjacentBlocks(BlockPos blockPos) {
        return new BlockPos[]{blockPos.func_177972_a(Direction.NORTH), blockPos.func_177972_a(Direction.SOUTH), blockPos.func_177972_a(Direction.EAST), blockPos.func_177972_a(Direction.WEST), blockPos.func_177972_a(Direction.UP)};
    }

    public static boolean isBlockGivenMaterial(World world, BlockPos blockPos, Material material) {
        return world.func_180495_p(blockPos).func_185904_a().equals(material);
    }

    @Deprecated
    public static Direction get2dOrientation(LivingEntity entity) {
        return entity.func_174811_aO();
    }

    public static float getRotationFromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case DOWN: {
                return -90.0f;
            }
            case UP: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static float getRotationFromOrientation(Orientation orientation) {
        return 0.0f;
    }

    public static Direction get3dOrientation(LivingEntity entity, BlockPos pos) {
        if (MathHelper.func_76135_e((float)((float)entity.func_226277_ct_() - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.func_226281_cx_() - (float)pos.func_177952_p())) < 2.0f) {
            double entityEyes = entity.func_226278_cu_() + (double)entity.func_70047_e();
            if (entityEyes - (double)pos.func_177956_o() > 2.0) {
                return Direction.DOWN;
            }
            if ((double)pos.func_177956_o() - entityEyes > 0.0) {
                return Direction.UP;
            }
        }
        return entity.func_174811_aO();
    }

    public static ItemEntity dropItemStackInWorld(World worldObj, Vector3i pos, @Nonnull ItemStack stack) {
        return UtilBlock.dropItemStackInWorld(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
    }

    public static ItemEntity dropItemStackInWorld(World worldObj, double x, double y, double z, @Nonnull ItemStack stack) {
        float f = 0.7f;
        float d0 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d1 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d2 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        ItemEntity entityitem = new ItemEntity(worldObj, x + (double)d0, y + (double)d1, z + (double)d2, stack);
        entityitem.func_174869_p();
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        worldObj.func_217376_c((Entity)entityitem);
        return entityitem;
    }

    public static ItemEntity ejectItemInDirection(World world, double x, double y, double z, Direction direction, @Nonnull ItemStack stack) {
        ItemEntity item = UtilBlock.dropItemStackInWorld(world, x, y, z, stack);
        Vector3i v = direction.func_176730_m();
        item.func_213293_j((double)((float)v.func_177958_n() / 5.0f), (double)((float)v.func_177956_o() / 5.0f), (double)((float)v.func_177952_p() / 5.0f));
        return item;
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            UtilBlock.dropItemStackInWorld(world, x, y, z, itemStack);
        }
    }

    public static void dropInventory(IInventory inventory, World world, int x, int y, int z) {
        UtilBlock.dropInventory(inventory, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public static TileEntity getTileInDirection(TileEntity tile, Direction direction) {
        BlockPos offset = tile.func_174877_v().func_177972_a(direction);
        return tile.func_145831_w().func_175625_s(offset);
    }

    public static TileEntity getTileInDirection(World world, BlockPos coord, Direction direction) {
        return world.func_175625_s(coord.func_177972_a(direction));
    }

    public static TileEntity getTileInDirectionSafe(World world, BlockPos coord, Direction direction) {
        BlockPos n = coord.func_177972_a(direction);
        return world.func_175667_e(n) ? world.func_175625_s(n) : null;
    }

    public static AxisAlignedBB expandAround(BlockPos pos, int x, int y, int z) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + x), (double)(pos.func_177956_o() + y), (double)(pos.func_177952_p() + z));
    }

    public static AxisAlignedBB expandAround(BlockPos pos, double x, double y, double z) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z);
    }

    public static AxisAlignedBB singleBlock(BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    public static void playSoundAtPos(World world, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound, category, volume, pitch);
    }

    public static AxisAlignedBB aabbOffset(BlockPos pos, AxisAlignedBB aabb) {
        return aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static AxisAlignedBB aabbOffset(BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBB((double)pos.func_177958_n() + x1, (double)pos.func_177956_o() + y1, (double)pos.func_177952_p() + z1, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2);
    }

    public static AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }
}

