/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import geni.witherutilsexp.api.common.util.UtilType;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;

public class UtilCollection {
    private static <A, B> Object allocateArray(Function<A, B> transformer, int length) {
        Class<?> transformerCls = transformer.getClass();
        Class<?> componentType = UtilCollection.findTypeFromGenericInterface(transformerCls);
        if (componentType == null) {
            componentType = UtilCollection.findTypeFromMethod(transformerCls);
        }
        Preconditions.checkState((componentType != null ? 1 : 0) != 0, (String)"Failed to find type for class %s", transformer);
        return Array.newInstance(componentType, length);
    }

    private static Class<?> findTypeFromGenericInterface(Class<?> cls) {
        TypeToken token = TypeToken.of(cls);
        TypeToken typeB = token.resolveType(UtilType.FUNCTION_B_PARAM);
        if (typeB.getType() instanceof Class) {
            return typeB.getRawType();
        }
        return null;
    }

    private static Class<?> findTypeFromMethod(Class<?> cls) {
        for (Method m : cls.getDeclaredMethods()) {
            Class<?> parameterType;
            Class<?>[] parameterTypes;
            if (!m.getName().equals("apply") || (parameterTypes = m.getParameterTypes()).length != 1 || (parameterType = parameterTypes[0]) == Object.class) continue;
            return parameterType;
        }
        return null;
    }

    private static <B, A> void transform(A[] input, Function<A, B> transformer, Object result) {
        for (int i = 0; i < input.length; ++i) {
            Object o = transformer.apply(input[i]);
            Array.set(result, i, o);
        }
    }

    public static <A, B> B[] transform(A[] input, Function<A, B> transformer) {
        Object result = UtilCollection.allocateArray(transformer, input.length);
        UtilCollection.transform(input, transformer, result);
        return (Object[])result;
    }

    public static <A, B> B[] transform(Class<? extends B> cls, A[] input, Function<A, B> transformer) {
        Object result = Array.newInstance(cls, input.length);
        UtilCollection.transform(input, transformer, result);
        return (Object[])result;
    }

    public static <A, B> B[] transform(Collection<A> input, Function<A, B> transformer) {
        Object result = UtilCollection.allocateArray(transformer, input.size());
        int i = 0;
        for (A a : input) {
            Object o = transformer.apply(a);
            Array.set(result, i++, o);
        }
        return (Object[])result;
    }
}

