/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UtilCompatibility {
    @Nullable
    public static IFluidHandler getFluidHandler(TileEntity te, Direction side) {
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).orElse(null);
    }

    public static IFluidHandler getTank(IWorldReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    @Nullable
    public static IItemHandler getItemHandler(TileEntity te, Direction side) {
        if (te == null) {
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
    }

    public static IItemHandler getItems(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
    }

    @Nullable
    public static IEnergyStorage getEnergyHandler(TileEntity te, Direction side) {
        if (te == null) {
            return null;
        }
        return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
    }

    public static IEnergyStorage getEnergy(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY).orElse(null);
    }

    public static boolean isFluidHandler(TileEntity te, Direction side) {
        return te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).isPresent();
    }

    public static boolean isItemHandler(TileEntity te, Direction side) {
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent();
    }

    public static boolean isEnergyHandler(TileEntity te, Direction side) {
        return te != null && te.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }
}

