/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import geni.witherutilsexp.api.client.render.FluidRenderMap;
import geni.witherutilsexp.api.common.data.Model3D;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class UtilFluid {
    public static final FluidRenderMap<Int2ObjectMap<Model3D>> cachedCenterFluids = new FluidRenderMap();
    public static final int stages = 1400;

    public static TextureAtlasSprite getBaseFluidTexture(@Nonnull Fluid fluid, @Nonnull FluidRenderMap.FluidType type) {
        ResourceLocation spriteLocation = type == FluidRenderMap.FluidType.STILL ? fluid.getAttributes().getStillTexture() : fluid.getAttributes().getFlowingTexture();
        return UtilFluid.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(spriteLocation);
    }

    public static Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        Model3D model = new Model3D();
        model.setTexture(FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            double belowSpacing;
            double sideSpacing = 0.00625;
            double topSpacing = belowSpacing = 0.015625;
            model.minX = sideSpacing;
            model.minY = belowSpacing;
            model.minZ = sideSpacing;
            model.maxX = 1.0 - sideSpacing;
            model.maxY = 1.0 - topSpacing;
            model.maxZ = 1.0 - sideSpacing;
        }
        if (cachedCenterFluids.containsKey(fluid)) {
            ((Int2ObjectMap)cachedCenterFluids.get(fluid)).put(stage, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(stage, (Object)model);
            cachedCenterFluids.put(fluid, map);
        }
        return model;
    }

    public static float getScale(FluidTank tank) {
        return UtilFluid.getScale(tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(int stored, int capacity, boolean empty) {
        float targetScale = (float)stored / (float)capacity;
        return targetScale;
    }

    public static IFluidHandler getTank(World world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    public static boolean tryFillPositionFromTank(World world, BlockPos posSide, Direction sideOpp, IFluidHandler tankFrom, int amount) {
        if (tankFrom == null) {
            return false;
        }
        try {
            IFluidHandler fluidTo = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)posSide, (Direction)sideOpp).orElse(null);
            if (fluidTo != null) {
                FluidStack wasDrained = tankFrom.drain(amount, IFluidHandler.FluidAction.SIMULATE);
                if (wasDrained == null) {
                    return false;
                }
                int filled = fluidTo.fill(wasDrained, IFluidHandler.FluidAction.SIMULATE);
                if (wasDrained != null && wasDrained.getAmount() > 0 && filled > 0) {
                    int realAmt = Math.min(filled, wasDrained.getAmount());
                    if ((wasDrained = tankFrom.drain(realAmt, IFluidHandler.FluidAction.EXECUTE)) == null) {
                        return false;
                    }
                    return fluidTo.fill(wasDrained, IFluidHandler.FluidAction.EXECUTE) > 0;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

