/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import com.google.common.collect.Lists;
import geni.witherutilsexp.api.common.util.UtilEnchantment;
import geni.witherutilsexp.registry.ConfigRegistry;
import geni.witherutilsexp.registry.FluidRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class UtilFluidXp {
    public static final int XP_PER_BOTTLE = 8;
    public static final IFluidXpConverter xpJuiceConverter = new XpJuice();
    private static final List<ConversionEntry> converters = Lists.newArrayList();
    public static final Function<FluidStack, FluidStack> FLUID_TO_LEVELS = input -> {
        if (input == null) {
            return null;
        }
        Optional<IFluidXpConverter> maybeConverter = UtilFluidXp.getConverter(input);
        return maybeConverter.map(converter -> {
            FluidStack result = input.copy();
            result.setAmount(UtilEnchantment.getLevelForExperience(converter.fluidToXp(input.getAmount())));
            return result;
        }).orElse(null);
    };

    public static void initializeFromConfig() {
        converters.add(new ConversionEntry(new FluidStack((Fluid)FluidRegistry.WITHERXP.get(), 1000), xpJuiceConverter));
        for (String entry : ConfigRegistry.additionalXpFluids) {
            int xpToFluid;
            String[] fields = entry.split(":");
            if (fields.length != 2) {
                System.out.println("Malformed XP fluid entry: %s" + entry);
                continue;
            }
            ResourceLocation fluidName = ResourceLocation.func_208304_a((String)fields[0]);
            if (fluidName == null) {
                System.out.println("Malformed fluid name: %s" + fields[0]);
                continue;
            }
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
            if (fluid == null) {
                System.out.println("Fluid not found: %s" + fluidName);
                continue;
            }
            try {
                xpToFluid = Integer.parseInt(fields[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid value in XP fluid entry: %s" + entry);
                continue;
            }
            converters.add(new ConversionEntry(new FluidStack(fluid, 1000), new Linear(xpToFluid)));
        }
    }

    public static FluidStack[] getAcceptedFluids() {
        FluidStack[] result = new FluidStack[converters.size()];
        int i = 0;
        for (ConversionEntry e : converters) {
            result[i++] = e.fluid.copy();
        }
        return result;
    }

    public static Optional<IFluidXpConverter> getConverter(FluidStack stack) {
        for (ConversionEntry e : converters) {
            if (!e.matches(stack)) continue;
            return e.optionalConverter;
        }
        return Optional.empty();
    }

    public static int getMaxPossibleFluidForLevel(int level) {
        int xp = UtilEnchantment.getExperienceForLevel(level);
        return UtilFluidXp.getMaxPossibleFluidForXp(xp);
    }

    public static int getMaxPossibleFluidForXp(int xp) {
        int result = 0;
        for (ConversionEntry e : converters) {
            result = Math.max(result, e.converter.xpToFluid(xp));
        }
        return result;
    }

    private static class ConversionEntry {
        private final FluidStack fluid;
        private final IFluidXpConverter converter;
        private final Optional<IFluidXpConverter> optionalConverter;

        public ConversionEntry(FluidStack fluid, IFluidXpConverter converter) {
            this.fluid = fluid;
            this.converter = converter;
            this.optionalConverter = Optional.of(converter);
        }

        public boolean matches(FluidStack input) {
            return this.fluid.isFluidEqual(input);
        }
    }

    public static interface IFluidXpConverter {
        public int fluidToXp(int var1);

        public int xpToFluid(int var1);
    }

    private static class Linear
    implements IFluidXpConverter {
        private final int xpToFluid;

        public Linear(int xpToFluid) {
            this.xpToFluid = xpToFluid;
        }

        @Override
        public int fluidToXp(int fluid) {
            return fluid / this.xpToFluid;
        }

        @Override
        public int xpToFluid(int xp) {
            return xp * this.xpToFluid;
        }
    }

    private static class XpJuice
    implements IFluidXpConverter {
        private XpJuice() {
        }

        @Override
        public int fluidToXp(int fluid) {
            return fluid / 20;
        }

        @Override
        public int xpToFluid(int xp) {
            return xp * 20;
        }
    }
}

