/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import geni.witherutilsexp.api.client.render.FakeBlockRenderTypes;
import geni.witherutilsexp.api.client.render.RenderResizableCuboid;
import geni.witherutilsexp.api.common.data.Model3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class UtilRender {
    public static final int FULL_LIGHT = 0xF000F0;

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uMaxLocal = uMax - uDif * (float)maskRight / (float)textureWidth;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vMaxLocal = vMax - vDif * (float)maskTop / (float)textureHeight;
                vertexBuffer.func_225582_a_((double)x, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMin, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMaxLocal, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMaxLocal, vMin).func_181675_d();
                vertexBuffer.func_225582_a_((double)x, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMin, vMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private static void renderCube(Matrix4f matrix, IVertexBuilder builder, BlockPos pos, Color color, float alpha) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    private static void renderModelBrightnessColorQuads(MatrixStack.Entry matrixEntry, IVertexBuilder builder, float red, float green, float blue, float alpha, List<BakedQuad> quads, int combinedLights, int combinedOverlay) {
        for (BakedQuad bakedquad : quads) {
            float b;
            float g;
            float r;
            if (bakedquad.func_178212_b()) {
                r = red * 1.0f;
                g = green * 1.0f;
                b = blue * 1.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            builder.addVertexData(matrixEntry, bakedquad, r, g, b, alpha, combinedLights, combinedOverlay);
        }
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int argb, int light) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light);
        }
    }

    public static int calculateGlowLight(int light, @Nonnull FluidStack fluid) {
        return fluid.isEmpty() ? light : UtilRender.calculateGlowLight(light, fluid.getFluid().getAttributes().getLuminosity(fluid));
    }

    public static int calculateGlowLight(int light, int glow) {
        if (glow >= 15) {
            return 0xF000F0;
        }
        int blockLight = LightTexture.func_228450_a_((int)light);
        int skyLight = LightTexture.func_228454_b_((int)light);
        return LightTexture.func_228451_a_((int)Math.max(blockLight, glow), (int)Math.max(skyLight, glow));
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        return UtilRender.getColorARGB(fluidStack);
    }

    private static int getColorARGB(@Nonnull FluidStack fluidStack) {
        return fluidStack.getFluid().getAttributes().getColor(fluidStack);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void renderAsBlock(BlockPos centerPos, List<BlockPos> shape, MatrixStack matrix, ItemStack stack, float alpha, float scale) {
        BlockState renderBlockState = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P();
        UtilRender.renderAsBlock(centerPos, shape, matrix, renderBlockState, alpha, scale);
    }

    public static void renderAsBlock(BlockPos centerPos, List<BlockPos> shape, MatrixStack matrix, BlockState renderBlockState, float alpha, float scale) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        double range = 6.0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockRayTraceResult lookingAt = (BlockRayTraceResult)player.func_213324_a(range, 0.0f, false);
        if (world.func_175623_d(lookingAt.func_216350_a())) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.FAKE_BLOCK);
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(-centerPos.func_177958_n()), (double)(-centerPos.func_177956_o()), (double)(-centerPos.func_177952_p()));
        for (BlockPos coordinate : shape) {
            float x = coordinate.func_177958_n();
            float y = coordinate.func_177956_o();
            float z = coordinate.func_177952_p();
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)x, (double)y, (double)z);
            matrix.func_227861_a_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
            matrix.func_227862_a_(scale, scale, scale);
            IBakedModel ibakedmodel = dispatcher.func_184389_a(renderBlockState);
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_228054_a_(renderBlockState, (IBlockDisplayReader)world, coordinate, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (renderBlockState.func_185901_i() == BlockRenderType.MODEL) {
                for (Direction direction : Direction.values()) {
                    UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, direction, new Random(MathHelper.func_180186_a((Vector3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 327680);
                }
                UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, null, new Random(MathHelper.func_180186_a((Vector3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    public static void renderOutline(BlockPos view, BlockPos pos, MatrixStack matrix, float scale, Color color) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        coords.add(pos);
        UtilRender.renderOutline(view, coords, matrix, scale, color);
    }

    public static void renderOutline(BlockPos view, List<BlockPos> coords, MatrixStack matrix, float scale, Color color) {
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(-view.func_177958_n()), (double)(-view.func_177956_o()), (double)(-view.func_177952_p()));
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.SOLID_COLOUR);
        for (BlockPos e : coords) {
            if (e == null) continue;
            matrix.func_227860_a_();
            float ctr = (1.0f - scale) / 2.0f;
            matrix.func_227861_a_((double)((float)e.func_177958_n() + ctr), (double)((float)e.func_177956_o() + ctr), (double)((float)e.func_177952_p() + ctr));
            matrix.func_227861_a_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            UtilRender.renderCube(positionMatrix, builder, e, color, 0.125f);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        buffer.func_228462_a_(FakeBlockRenderTypes.SOLID_COLOUR);
    }

    public static void renderOutline(BlockPos view, List<BlockPos> coords, MatrixStack matrix) {
        UtilRender.renderOutline(view, coords, matrix, 0.7f, Color.BLUE);
    }

    public static BlockRayTraceResult getLookingAt(PlayerEntity player, int range) {
        return (BlockRayTraceResult)player.func_213324_a((double)range, 0.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderColourCubes(RenderWorldLastEvent evt, Map<BlockPos, Color> coords, float alpha) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        float scale = 1.01f;
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        Vector3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = evt.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
        for (BlockPos posCurr : coords.keySet()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)posCurr.func_177958_n(), (double)posCurr.func_177956_o(), (double)posCurr.func_177952_p());
            matrix.func_227861_a_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            UtilRender.renderCube(matrix.func_227866_c_().func_227870_a_(), builder, posCurr, coords.get(posCurr), alpha);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
    }
}

