/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.tank;

import geni.witherutilsexp.api.common.block.BaseBlock;
import geni.witherutilsexp.api.common.capability.FluidHandlerCapabilityStack;
import geni.witherutilsexp.block.tank.TankRenderer;
import geni.witherutilsexp.block.tank.TankTile;
import geni.witherutilsexp.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class TankBlock
extends BaseBlock {
    protected static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TankBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.setHasFluidInteract();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_SHAPE;
    }

    @Deprecated
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TankTile();
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(TileRegistry.TANKTILE, TankRenderer::new);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            TileEntity container = world.func_175625_s(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        world.func_175656_a(pos, state);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack tankStack = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IFluidHandler fluidInTile = (IFluidHandler)ent.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
            IFluidHandler fluidInStack = (IFluidHandler)tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            if (fluidInStack != null) {
                FluidStack fs = fluidInTile.getFluidInTank(0);
                ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tankStack));
        }
    }
}

