/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.tank;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import geni.witherutilsexp.api.client.render.FluidTankRenderType;
import geni.witherutilsexp.api.common.util.UtilFluid;
import geni.witherutilsexp.api.common.util.UtilRender;
import geni.witherutilsexp.block.tank.TankTile;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@OnlyIn(value=Dist.CLIENT)
public class TankRenderer
extends TileEntityRenderer<TankTile> {
    public TankRenderer(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(TankTile tankHere, float v, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight) {
        IFluidHandler handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
        if (handler == null || handler.getFluidInTank(0) == null) {
            return;
        }
        FluidStack fluid = handler.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return;
        }
        matrix.func_227861_a_((double)0.08f, 0.0, (double)0.08f);
        IVertexBuilder bufferA = renderer.getBuffer(FluidTankRenderType.resizableCuboid());
        matrix.func_227862_a_(0.85f, UtilFluid.getScale(tankHere.tank), 0.85f);
        UtilRender.renderObject(UtilFluid.getFluidModel(fluid, 1399), matrix, bufferA, UtilRender.getColorARGB(fluid, 0.1f), UtilRender.calculateGlowLight(light, fluid));
    }
}

