/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.xpshower;

import geni.witherutilsexp.api.common.block.BaseBlock;
import geni.witherutilsexp.api.common.util.UtilCompatibility;
import geni.witherutilsexp.block.xpshower.XPShowerTile;
import geni.witherutilsexp.registry.BlockRegistry;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class XPShowerBlock
extends BaseBlock
implements ITileEntityProvider {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public XPShowerBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vector3d offset = state.func_191059_e(world, pos);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)7.0, (double)1.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)14.2, (double)10.0), XPShowerBlock.func_208617_a((double)7.0, (double)13.0, (double)5.0, (double)13.0, (double)14.0, (double)11.0), XPShowerBlock.func_208617_a((double)13.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), XPShowerBlock.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case EAST: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)3.0, (double)1.0, (double)5.0, (double)9.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)4.0, (double)0.0, (double)6.0, (double)8.0, (double)14.2, (double)10.0), XPShowerBlock.func_208617_a((double)3.0, (double)13.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0), XPShowerBlock.func_208617_a((double)1.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), XPShowerBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case NORTH: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)5.0, (double)1.0, (double)7.0, (double)11.0, (double)12.0, (double)13.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)14.2, (double)12.0), XPShowerBlock.func_208617_a((double)5.0, (double)13.0, (double)7.0, (double)11.0, (double)14.0, (double)13.0), XPShowerBlock.func_208617_a((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)15.0), XPShowerBlock.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case SOUTH: 
        }
        return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)5.0, (double)1.0, (double)3.0, (double)11.0, (double)12.0, (double)9.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)14.2, (double)8.0), XPShowerBlock.func_208617_a((double)5.0, (double)13.0, (double)3.0, (double)11.0, (double)14.0, (double)9.0), XPShowerBlock.func_208617_a((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), XPShowerBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public VoxelShape func_199600_g(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        Vector3d offset = state.func_191059_e(world, pos);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)7.0, (double)1.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)14.2, (double)10.0), XPShowerBlock.func_208617_a((double)7.0, (double)13.0, (double)5.0, (double)13.0, (double)14.0, (double)11.0), XPShowerBlock.func_208617_a((double)13.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), XPShowerBlock.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case EAST: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)3.0, (double)1.0, (double)5.0, (double)9.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)4.0, (double)0.0, (double)6.0, (double)8.0, (double)14.2, (double)10.0), XPShowerBlock.func_208617_a((double)3.0, (double)13.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0), XPShowerBlock.func_208617_a((double)1.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), XPShowerBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case NORTH: {
                return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)5.0, (double)1.0, (double)7.0, (double)11.0, (double)12.0, (double)13.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)14.2, (double)12.0), XPShowerBlock.func_208617_a((double)5.0, (double)13.0, (double)7.0, (double)11.0, (double)14.0, (double)13.0), XPShowerBlock.func_208617_a((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)15.0), XPShowerBlock.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case SOUTH: 
        }
        return VoxelShapes.func_216384_a((VoxelShape)XPShowerBlock.func_208617_a((double)5.0, (double)1.0, (double)3.0, (double)11.0, (double)12.0, (double)9.0), (VoxelShape[])new VoxelShape[]{XPShowerBlock.func_208617_a((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)14.2, (double)8.0), XPShowerBlock.func_208617_a((double)5.0, (double)13.0, (double)3.0, (double)11.0, (double)14.0, (double)9.0), XPShowerBlock.func_208617_a((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), XPShowerBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0)}).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            boolean swap = (Boolean)state.func_177229_b((Property)POWERED);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(!swap)), 3);
            float f = (Boolean)state.func_177229_b((Property)POWERED) != false ? 0.6f : 0.5f;
            world.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.3f, f);
            XPShowerTile tileentity = (XPShowerTile)world.func_175625_s(pos);
            tileentity.setActive(!swap);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canPlaceAt(world, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(IWorldReader world, BlockPos pos, Direction facing) {
        boolean isSide = facing.func_176740_k().func_176722_c();
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && isSide) {
            return true;
        }
        return isSide && UtilCompatibility.getTank(world, pos, facing) != null;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        if (!this.canPlaceAt((IWorldReader)world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            XPShowerBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)BlockRegistry.XPSHOWER.func_199767_j(), 1));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new XPShowerTile();
    }
}

