/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.xpshower;

import geni.witherutilsexp.api.common.network.PacketShowerParticle;
import geni.witherutilsexp.api.common.tile.BaseTile;
import geni.witherutilsexp.block.xpshower.XPShowerBlock;
import geni.witherutilsexp.registry.FluidRegistry;
import geni.witherutilsexp.registry.PacketRegistry;
import geni.witherutilsexp.registry.TileRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.PacketDistributor;

public class XPShowerTile
extends BaseTile
implements ITickableTileEntity {
    public boolean active;

    public XPShowerTile() {
        super(TileRegistry.XPSHOWERTILE);
    }

    public void func_73660_a() {
        TileEntity tileentity;
        if (!this.func_145831_w().field_72995_K && this.active && (tileentity = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(((Direction)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((Property)XPShowerBlock.FACING)).func_176734_d()))) != null) {
            LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((Property)XPShowerBlock.FACING));
            fluidHandler.ifPresent(handler -> {
                if (handler.getFluidInTank(0).getAmount() >= 20 && this.func_145831_w().func_82737_E() % 3L == 0L) {
                    if (handler.getFluidInTank(0).getFluid().getFluid().equals(FluidRegistry.WITHERXP.get())) {
                        int xpAmount = ExperienceOrbEntity.func_70527_a((int)Math.min(20, handler.getFluidInTank(0).getAmount() / 20));
                        if (!handler.drain(xpAmount * 20, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                            this.spawnXP(this.func_145831_w(), this.field_174879_c.func_177977_b(), xpAmount, tileentity);
                            PacketRegistry.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PacketShowerParticle(this.func_174877_v()));
                        }
                    } else if (handler.getFluidInTank(0).getAmount() >= 1000 && handler.getFluidInTank(0).getFluid().func_207188_f() != null && handler.getFluidInTank(0).getFluid().func_207188_f().func_206883_i() != null) {
                        BlockState state = handler.getFluidInTank(0).getFluid().func_207188_f().func_206883_i();
                        if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177972_a(Direction.DOWN)) && this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(Direction.DOWN), state)) {
                            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
            });
        }
    }

    public void spawnXP(World world, BlockPos pos, int xp, TileEntity tankTile) {
        tankTile.func_70296_d();
        ExperienceOrbEntity orb = new ExperienceOrbEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.125, (double)pos.func_177952_p() + 0.5, xp);
        world.func_217376_c((Entity)orb);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    public void readFromNBT(BlockState bs, CompoundNBT nbt) {
        super.func_230337_a_(bs, nbt);
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeToNBT(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

