/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.xpsucker;

import geni.witherutilsexp.api.common.block.BaseBlock;
import geni.witherutilsexp.api.common.util.UtilCompatibility;
import geni.witherutilsexp.block.xpsucker.XPSuckerTile;
import geni.witherutilsexp.registry.BlockRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class XPSuckerBlock
extends BaseBlock
implements ITileEntityProvider {
    protected static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public XPSuckerBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canPlaceAt(world, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(IWorldReader world, BlockPos pos, Direction facing) {
        boolean isTop = facing.func_176740_k().func_200128_b();
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && isTop) {
            return true;
        }
        return isTop && UtilCompatibility.getTank(world, pos, facing) != null;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        if (!this.canPlaceAt((IWorldReader)world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            XPSuckerBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)BlockRegistry.XPSUCKER.func_199767_j(), 1));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new XPSuckerTile();
    }
}

