/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.block.xpsucker;

import geni.witherutilsexp.api.common.network.PacketShowerParticle;
import geni.witherutilsexp.api.common.tile.BaseTile;
import geni.witherutilsexp.block.xpsucker.XPSuckerBlock;
import geni.witherutilsexp.registry.FluidRegistry;
import geni.witherutilsexp.registry.PacketRegistry;
import geni.witherutilsexp.registry.TileRegistry;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.PacketDistributor;

public class XPSuckerTile
extends BaseTile
implements ITickableTileEntity {
    public XPSuckerTile() {
        super(TileRegistry.XPSUCKERTILE);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        TileEntity tileentity = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(((Direction)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((Property)XPSuckerBlock.FACING)).func_176734_d()));
        if (tileentity != null) {
            LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((Property)XPSuckerBlock.FACING));
            fluidHandler.ifPresent(handler -> {
                if (handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).getFluid().func_207187_a((Fluid)FluidRegistry.WITHERXP.get())) {
                    this.captureDroppedXP((IFluidHandler)handler);
                }
            });
        }
    }

    public boolean captureDroppedXP(IFluidHandler handler) {
        Iterator<PlayerEntity> iterator = this.getCaptureXP(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5).iterator();
        if (iterator.hasNext()) {
            PlayerEntity player = iterator.next();
            int xpAmount = XPSuckerTile.getPlayerXP(player);
            if (xpAmount <= 0) {
                return false;
            }
            if (handler.getFluidInTank(0).getAmount() < handler.getTankCapacity(0)) {
                handler.fill(new FluidStack((Fluid)FluidRegistry.WITHERXP.get(), 20), IFluidHandler.FluidAction.EXECUTE);
                XPSuckerTile.addPlayerXP(player, -1);
                this.func_145831_w().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 0.1f, 0.5f * ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.8f));
                PacketRegistry.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PacketShowerParticle(this.func_174877_v().func_177984_a()));
            }
            return true;
        }
        return false;
    }

    public List<PlayerEntity> getCaptureXP(World world, double x, double y, double z) {
        return world.func_175647_a(PlayerEntity.class, new AxisAlignedBB(x - 0.45, y - 0.5, z - 0.45, x + 0.45, y + 1.03, z + 0.45), EntityPredicates.field_94557_a);
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = XPSuckerTile.getPlayerXP(player) + amount;
        player.field_71068_ca = XPSuckerTile.getLevelForExperience(experience);
        int expForLevel = XPSuckerTile.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)XPSuckerTile.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (XPSuckerTile.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

