/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.registry;

import com.google.common.base.Supplier;
import geni.witherutilsexp.api.common.network.BasePacket;
import geni.witherutilsexp.api.common.network.PacketFluidSync;
import geni.witherutilsexp.api.common.network.PacketShowerParticle;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRegistry {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("witherutilsexp", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void setup() {
        int id = 0;
        INSTANCE.registerMessage(id++, PacketFluidSync.class, PacketFluidSync::encode, PacketFluidSync::decode, PacketFluidSync::handle);
        INSTANCE.registerMessage(id++, PacketShowerParticle.class, PacketShowerParticle::encode, PacketShowerParticle::decode, PacketShowerParticle::handle);
    }

    public static void sendToAllClients(World world, BasePacket packet) {
        for (PlayerEntity player : world.func_217369_A()) {
            ServerPlayerEntity sp = (ServerPlayerEntity)player;
            INSTANCE.sendTo((Object)packet, sp.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToNearby(World world, BlockPos pos, Object toSend) {
        if (world instanceof ServerWorld) {
            ServerWorld ws = (ServerWorld)world;
            ws.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).filter(p -> p.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 4096.0).forEach(p -> INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(World world, Entity e, Object toSend) {
        PacketRegistry.sendToNearby(world, e.func_233580_cy_(), toSend);
    }

    public static class OverlayTextMessage {
        public static final int DISPLAY_TIME_MS = 3000;
        private static BiConsumer<ITextComponent, Integer> handler_ = null;
        private ITextComponent data_;
        private int delay_ = 3000;

        private ITextComponent data() {
            return this.data_;
        }

        private int delay() {
            return this.delay_;
        }

        public static void setHandler(BiConsumer<ITextComponent, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(PlayerEntity player, ITextComponent message, int delay) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer) {
                return;
            }
            INSTANCE.sendTo((Object)new OverlayTextMessage(message, delay), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public OverlayTextMessage() {
            this.data_ = new TranslationTextComponent("[unset]");
        }

        public OverlayTextMessage(ITextComponent tct, int delay) {
            this.data_ = tct.func_230532_e_();
            this.delay_ = delay;
        }

        public static OverlayTextMessage parse(PacketBuffer buf) {
            try {
                return new OverlayTextMessage(buf.func_179258_d(), 3000);
            }
            catch (Throwable e) {
                return new OverlayTextMessage((ITextComponent)new TranslationTextComponent("[incorrect translation]"), 3000);
            }
        }

        public static void compose(OverlayTextMessage pkt, PacketBuffer buf) {
            try {
                buf.func_179256_a(pkt.data());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static class Handler {
            public static void handle(OverlayTextMessage pkt, Supplier<NetworkEvent.Context> ctx) {
                if (handler_ != null) {
                    ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> handler_.accept(pkt.data(), pkt.delay()));
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        }
    }
}

