/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.fakeblocks.blocks;

import de.maxhenkel.fakeblocks.Main;
import de.maxhenkel.fakeblocks.blocks.tileentity.FakeBlockTileEntity;
import de.maxhenkel.fakeblocks.corelib.block.IItemBlock;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FakeBlock
extends Block
implements ITileEntityProvider,
IItemBlock {
    public static final Material MATERIAL = new Material(MaterialColor.field_151660_b, false, false, false, true, false, false, PushReaction.BLOCK);
    protected static final VoxelShape SHAPE_EMPTY = VoxelShapes.func_197880_a();
    protected static final VoxelShape SHAPE_FULL = VoxelShapes.func_197868_b();

    public FakeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)MATERIAL).func_200943_b(0.25f).func_200947_a(SoundType.field_222470_q).func_200942_a());
        this.setRegistryName(new ResourceLocation("fakeblocks", "fakeblock"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        FakeBlockTileEntity fakeBlock = FakeBlock.getTileEntity((IBlockReader)worldIn, pos).orElse(null);
        if (fakeBlock != null && fakeBlock.getBlock() == null) {
            BlockState setBlockState;
            Block block;
            if (heldItem.func_77973_b() instanceof BlockItem && Block.func_208062_a((VoxelShape)(block = ((BlockItem)heldItem.func_77973_b()).func_179223_d()).func_220071_b(setBlockState = block.func_196258_a(new BlockItemUseContext(new ItemUseContext(player, handIn, hit))), (IBlockReader)worldIn, pos, ISelectionContext.func_216377_a())) && block.func_149645_b(setBlockState) == BlockRenderType.MODEL && !Main.SERVER_CONFIG.fakeBlockBlacklist.contains(block)) {
                if (!worldIn.field_72995_K) {
                    fakeBlock.setBlockState(setBlockState);
                    SoundType type = block.func_220072_p(setBlockState);
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, type.func_185841_e(), SoundCategory.BLOCKS, type.func_185843_a(), type.func_185847_b());
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (fakeBlock != null && fakeBlock.getBlock() != null) {
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        Optional<FakeBlockTileEntity> tileEntity = FakeBlock.getTileEntity((IBlockReader)world, pos);
        if (tileEntity.isPresent() && tileEntity.get().getBlock() != null) {
            if (!world.field_72995_K) {
                BlockState blockState = tileEntity.get().getBlock();
                SoundType type = blockState.func_177230_c().func_220072_p(blockState);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, type.func_185841_e(), SoundCategory.BLOCKS, type.func_185843_a(), type.func_185847_b());
                tileEntity.get().setBlockState(null);
                if (!player.func_184812_l_()) {
                    FakeBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)blockState.func_177230_c()));
                }
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public static Optional<FakeBlockTileEntity> getTileEntity(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FakeBlockTileEntity) {
            return Optional.of((FakeBlockTileEntity)te);
        }
        return Optional.empty();
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        Optional<FakeBlockTileEntity> tileEntity = FakeBlock.getTileEntity((IBlockReader)world, pos);
        if (tileEntity.isPresent() && tileEntity.get().getBlock() != null) {
            return tileEntity.get().getBlock().func_177230_c().getSoundType(state, world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new FakeBlockTileEntity();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_EMPTY;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE_FULL;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE_FULL;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Optional<FakeBlockTileEntity> tileEntity = FakeBlock.getTileEntity(world, pos);
        return tileEntity.isPresent() && tileEntity.get().getBlock() != null ? new ItemStack((IItemProvider)tileEntity.get().getBlock().func_177230_c()) : super.getPickBlock(state, target, world, pos, player);
    }
}

