/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import com.google.common.collect.Lists;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.datastorage.BetterWeatherData;
import corgitaco.betterweather.weatherevents.AcidRain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="betterweather")
public class BetterWeather {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "betterweather";
    static boolean damageAnimals = false;
    static boolean damageMonsters = false;
    static boolean damagePlayer = false;

    public BetterWeather() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        BetterWeatherConfig.loadConfig(BetterWeatherConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("betterweather-common.toml"));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        BetterWeatherConfig.loadConfig(BetterWeatherConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("betterweather-common.toml"));
        String entityTypes = (String)BetterWeatherConfig.entityTypesToDamage.get();
        String removeSpaces = entityTypes.trim().toLowerCase().replace(" ", "");
        List<String> entityList = Arrays.asList(removeSpaces.split(","));
        for (String s : entityList) {
            if (s.equalsIgnoreCase("animal") && !damageAnimals) {
                damageAnimals = true;
            }
            if (s.equalsIgnoreCase("monster") && !damageMonsters) {
                damageMonsters = true;
            }
            if (!s.equalsIgnoreCase("player") || damagePlayer) continue;
            damageMonsters = true;
        }
    }

    public void clientSetup(FMLClientSetupEvent event) {
        Minecraft minecraft = (Minecraft)event.getMinecraftSupplier().get();
        GameRenderer gameRenderer = minecraft.field_71460_t;
    }

    public static enum WeatherType {
        BLIZZARD,
        HAIL,
        HEATWAVE,
        WINDSTORM,
        SANDSTORM,
        ACIDRAIN;

    }

    @Mod.EventBusSubscriber(modid="betterweather", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BetterWeatherEvents {
        public static BetterWeatherData weatherData = null;
        public static final ResourceLocation RAIN_TEXTURE = new ResourceLocation("textures/environment/rain.png");
        public static final ResourceLocation ACID_RAIN_TEXTURE = new ResourceLocation("betterweather", "textures/environment/acid_rain.png");

        @SubscribeEvent
        public static void worldTick(TickEvent.WorldTickEvent event) {
            BetterWeatherEvents.setWeatherData((IWorld)event.world);
            if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
                ServerWorld serverWorld = (ServerWorld)event.world;
                World world = event.world;
                int tickSpeed = world.func_82736_K().func_223592_c(GameRules.field_223610_m);
                long worldTime = world.func_72912_H().func_82573_f();
                if (worldTime % 5000L == 0L && !event.world.func_72912_H().func_76059_o()) {
                    Random random = world.field_73012_v;
                    weatherData.setAcidRain((double)random.nextFloat() < (Double)BetterWeatherConfig.acidRainChance.get());
                }
                ArrayList list = Lists.newArrayList((Iterable)serverWorld.func_72863_F().field_217237_a.func_223491_f());
                list.forEach(chunkHolder -> {
                    Optional optional1;
                    Optional optional = chunkHolder.func_219296_a().getNow(ChunkHolder.field_219308_c).left();
                    if (optional.isPresent() && (optional1 = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left()).isPresent()) {
                        Chunk chunk = (Chunk)optional1.get();
                        AcidRain.acidRainEvent(chunk, serverWorld, tickSpeed, worldTime);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void renderTickEvent(TickEvent.RenderTickEvent event) {
        }

        @SubscribeEvent
        public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
            BetterWeatherEvents.setWeatherData((IWorld)event.player.field_70170_p);
        }

        @SubscribeEvent
        public static void entityTickEvent(LivingEvent.LivingUpdateEvent event) {
            BlockPos entityPos;
            Entity entity;
            World world;
            if (damageMonsters && event.getEntity().getClassification(true) == EntityClassification.MONSTER && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos((entity = event.getEntity()).func_213303_ch())) && weatherData.isAcidRain() && world.func_72912_H().func_76059_o() && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
                entity.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            if (damageAnimals && (event.getEntity().getClassification(true) == EntityClassification.CREATURE || event.getEntity().getClassification(true) == EntityClassification.AMBIENT) && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos((entity = event.getEntity()).func_213303_ch())) && weatherData.isAcidRain() && world.func_72912_H().func_76059_o() && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
                entity.func_70097_a(DamageSource.field_76377_j, ((Double)BetterWeatherConfig.hurtEntityDamage.get()).floatValue());
            }
            if (damagePlayer && event.getEntity() instanceof PlayerEntity && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos((entity = event.getEntity()).func_213303_ch())) && weatherData.isAcidRain() && world.func_72912_H().func_76059_o() && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
                entity.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
        }

        @SubscribeEvent
        public static void clientTickEvent(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71441_e != null) {
                BetterWeatherEvents.setWeatherData((IWorld)minecraft.field_71441_e);
                if (minecraft.field_71441_e.func_72912_H().func_76059_o() && weatherData.isAcidRain()) {
                    if (!((Boolean)BetterWeatherConfig.removeSmokeParticles.get()).booleanValue()) {
                        AcidRain.addAcidRainParticles(minecraft.field_71460_t.func_215316_n(), minecraft, minecraft.field_71438_f);
                    }
                    if (WorldRenderer.field_228413_h_ != ACID_RAIN_TEXTURE && weatherData.isAcidRain()) {
                        WorldRenderer.field_228413_h_ = ACID_RAIN_TEXTURE;
                    } else if (WorldRenderer.field_228413_h_ != RAIN_TEXTURE && !weatherData.isAcidRain()) {
                        WorldRenderer.field_228413_h_ = RAIN_TEXTURE;
                    }
                }
            }
        }

        public static void setWeatherData(IWorld world) {
            if (weatherData == null) {
                weatherData = BetterWeatherData.get(world);
            }
        }
    }
}

