/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class ScreenshotLoader {
    public static class_2960 SCREENSHOT = new class_2960("visualconnect", "screenshot");
    public static double imageRatio = 1.0;
    public static boolean loaded = false;
    public static boolean allowCustomScreenshot = false;
    public static boolean inFade = false;
    public static int time;
    public static float timeDelta;
    private static String fileName;
    private static final Pattern RESERVED_FILENAMES_PATTERN;

    public static String getFileName() {
        return fileName;
    }

    public static void setScreenshot(String address, int port) {
        fileName = "screenshots/worlds/servers/" + address + "_" + port + ".png";
        ScreenshotLoader.setScreenshot();
    }

    public static void setScreenshot(String worldName) {
        fileName = "screenshots/worlds/singleplayer/" + worldName + ".png";
        ScreenshotLoader.setScreenshot();
    }

    public static void setRealmScreenshot(String realmName) {
        fileName = "screenshots/worlds/realms/" + ScreenshotLoader.cleanFileName(realmName) + ".png";
        ScreenshotLoader.setScreenshot();
    }

    private static void setScreenshot() {
        loaded = false;
        try (FileInputStream in = new FileInputStream(fileName);){
            System.out.println("Name: " + fileName);
            class_1043 image = new class_1043(class_1011.method_4309((InputStream)in));
            class_310.method_1551().method_1531().method_4616(SCREENSHOT, (class_1044)image);
            imageRatio = (double)image.method_4525().method_4307() / (double)image.method_4525().method_4323();
            loaded = true;
            time = Config.time;
            timeDelta = 1.0f / (float)Config.fade;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String cleanFileName(String fileName) {
        for (char c : class_155.field_1126) {
            fileName = ((String)fileName).replace(c, '_');
        }
        if (RESERVED_FILENAMES_PATTERN.matcher((CharSequence)fileName).matches()) {
            fileName = "_" + (String)fileName + "_";
        }
        if (((String)fileName).length() > 251) {
            fileName = ((String)fileName).substring(0, 251);
        }
        return fileName;
    }

    public static void render(class_437 screen, class_4587 stack) {
        if (loaded) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)SCREENSHOT);
            int w = (int)(imageRatio * (double)screen.field_22790);
            class_332.method_25290((class_4587)stack, (int)(screen.field_22789 / 2 - w / 2), (int)0, (float)0.0f, (float)0.0f, (int)w, (int)screen.field_22790, (int)w, (int)screen.field_22790);
        }
    }

    static {
        fileName = "";
        RESERVED_FILENAMES_PATTERN = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    }
}

