/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.impl.config.client.ConfigListerScreen;
import net.flytre.flytre_lib.impl.config.client.GenericConfigScreen;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientForgeEventBus {
    private static final ResourceLocation FLYTRE_LIB_TAB = new ResourceLocation("flytre_lib:textures/gui/config/tab.png");
    private static final ResourceLocation TAB_BACKGROUND = new ResourceLocation("flytre_lib:textures/gui/config/background.png");
    private static final float ANIMATION_TIME = 20.0f;
    private float libAnimationProgress = -1.0f;
    private boolean animating = false;

    public ClientForgeEventBus() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void screenDrawEvent(ScreenEvent.DrawScreenEvent event) {
        if (!(event.getScreen() instanceof TitleScreen)) {
            return;
        }
        PoseStack matrices = event.getPoseStack();
        int height = event.getScreen().f_96544_;
        int width = event.getScreen().f_96543_;
        float delta = event.getPartialTicks();
        if (!LoaderProperties.HANDLER.getConfig().displayTitleScreenConfigButton) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 100.0);
        int y = Math.min(height * 2 / 3, height - 80);
        RenderSystem.m_157456_((int)0, (ResourceLocation)FLYTRE_LIB_TAB);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69478_();
        if (!this.animating) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)0, (int)y, (float)0.0f, (float)0.0f, (int)42, (int)80, (int)42, (int)80);
        }
        if (this.animating) {
            this.libAnimationProgress -= delta;
            if (this.libAnimationProgress < 0.0f) {
                this.animating = false;
                Minecraft.m_91087_().m_91152_((Screen)new ConfigListerScreen(event.getScreen()).disableAnimation());
            }
            int maxX = width - 42;
            int currX = (int)((float)maxX * ((20.0f - this.libAnimationProgress) / 20.0f));
            GuiComponent.m_93133_((PoseStack)matrices, (int)currX, (int)y, (float)0.0f, (float)0.0f, (int)42, (int)80, (int)42, (int)80);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TAB_BACKGROUND);
            GenericConfigScreen.tile(new Rectangle(currX - 1, height), 0, 1.0f, 255);
        }
        matrices.m_85849_();
    }

    @SubscribeEvent
    public void screenMouseClicked(ScreenEvent.MouseClickedEvent event) {
        if (!(event.getScreen() instanceof TitleScreen)) {
            return;
        }
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int height = event.getScreen().f_96544_;
        if (!LoaderProperties.HANDLER.getConfig().displayTitleScreenConfigButton) {
            return;
        }
        int y = Math.min(height * 2 / 3, height - 80);
        Rectangle bounds = new Rectangle(0, y, 42, 80);
        if (bounds.contains(mouseX, mouseY) && !this.animating) {
            this.libAnimationProgress = 20.0f;
            this.animating = true;
            event.setCanceled(true);
        }
    }
}

