/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.compat.wrench;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class WrenchObservers {
    private static final List<Consumer<UseOnContext>> USE_ON_BLOCK_OBSERVERS = new ArrayList<Consumer<UseOnContext>>();
    private static final List<TickAction> SHIFT_TICK_OBSERVERS = new ArrayList<TickAction>();
    private static final List<TickAction> NO_SHIFT_TICK_OBSERVERS = new ArrayList<TickAction>();

    private WrenchObservers() {
    }

    public static void addUseOnBlockObserver(Consumer<UseOnContext> observer) {
        USE_ON_BLOCK_OBSERVERS.add(observer);
    }

    public static void addShiftTickObserver(TickAction observer) {
        SHIFT_TICK_OBSERVERS.add(observer);
    }

    public static void addNoShiftTickObserver(TickAction observer) {
        NO_SHIFT_TICK_OBSERVERS.add(observer);
    }

    public static void onUseOnBlock(UseOnContext context) {
        USE_ON_BLOCK_OBSERVERS.forEach(observer -> observer.accept(context));
    }

    public static void onShiftTick(Level world, BlockHitResult hitResult, Block block, Player player, BlockState state, BlockEntity blockEntity) {
        SHIFT_TICK_OBSERVERS.forEach(observer -> observer.onTick(world, hitResult, block, player, state, blockEntity));
    }

    public static void onShiftlessTick(Level world, BlockHitResult hitResult, Block block, Player player, BlockState state, BlockEntity blockEntity) {
        NO_SHIFT_TICK_OBSERVERS.forEach(observer -> observer.onTick(world, hitResult, block, player, state, blockEntity));
    }

    @FunctionalInterface
    public static interface TickAction {
        public void onTick(Level var1, BlockHitResult var2, Block var3, Player var4, BlockState var5, BlockEntity var6);
    }
}

