/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.math;

public final class Rectangle {
    public static final Rectangle DEFAULT = new Rectangle(0, 0, 0, 0);
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width *= -1;
        }
        if (height < 0) {
            y += height;
            height *= -1;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static Rectangle fromBounds(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public int getLeft() {
        return this.x;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getTop() {
        return this.y;
    }

    public int getBottom() {
        return this.y + this.height;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(double x, double y) {
        return (double)this.x <= x && (double)this.y <= y && (double)(this.x + this.width) >= x && (double)(this.y + this.height) >= y;
    }

    public Rectangle reducedBy(int amount) {
        return new Rectangle(this.x + amount, this.y + amount, this.width - amount * 2, this.height - amount * 2);
    }

    public Rectangle expandedBy(int amount) {
        return this.reducedBy(-amount);
    }

    public Rectangle horizontallyExpandedBy(int amount) {
        return new Rectangle(this.x - amount, this.y, this.width + amount * 2, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (this.x != rectangle.x) {
            return false;
        }
        if (this.y != rectangle.y) {
            return false;
        }
        if (this.width != rectangle.width) {
            return false;
        }
        return this.height == rectangle.height;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public String toString() {
        return "Rectangle{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "}";
    }
}

