/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class BlockManipulator {
    private BlockManipulator() {
    }

    public static void place(ServerLevel world, StructureTemplate structure, BlockPos pos) {
        BlockManipulator.place(world, structure, pos, 1.0f, Mirror.NONE, Rotation.NONE, false);
    }

    public static void place(ServerLevel world, StructureTemplate structure, BlockPos pos, float integrity, Mirror mirror, Rotation rotation, boolean ignoreEntities) {
        StructurePlaceSettings structurePlacementData = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rotation).m_74392_(ignoreEntities);
        if (integrity < 1.0f) {
            structurePlacementData.m_74394_().m_74383_((StructureProcessor)new BlockRotProcessor(Mth.m_14036_((float)integrity, (float)0.0f, (float)1.0f))).m_74390_(new Random(Util.m_137550_()));
        }
        structure.m_74536_((ServerLevelAccessor)world, pos, pos, structurePlacementData, new Random(Util.m_137550_()), 2);
    }

    public static Collection<BlockPos> getBlocksInRegion(BlockPos one, BlockPos two) {
        BlockPos min = new BlockPos(Math.min(one.m_123341_(), two.m_123341_()), Math.min(one.m_123342_(), two.m_123342_()), Math.min(one.m_123343_(), two.m_123343_()));
        BlockPos max = new BlockPos(Math.max(one.m_123341_(), two.m_123341_()), Math.max(one.m_123342_(), two.m_123342_()), Math.max(one.m_123343_(), two.m_123343_()));
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int i = min.m_123341_(); i <= max.m_123341_(); ++i) {
            for (int j = min.m_123342_(); j <= max.m_123342_(); ++j) {
                for (int k = min.m_123343_(); k <= max.m_123343_(); ++k) {
                    result.add(new BlockPos(i, j, k));
                }
            }
        }
        return result;
    }

    public static void forBlockInRegion(BlockPos one, BlockPos two, Consumer<BlockPos> actor) {
        BlockManipulator.getBlocksInRegion(one, two).forEach(actor);
    }
}

