/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class EnchantmentUtils {
    private EnchantmentUtils() {
        throw new AssertionError();
    }

    public static int calculateTotalXp(Player player) {
        return (int)((float)EnchantmentUtils.getExperienceFromLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int nextLevelExperience(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceFromLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static int getExperienceLevel(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = EnchantmentUtils.nextLevelExperience(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static void modifyEnchants(ItemStack stack, Consumer<Map<Enchantment, Integer>> modifier) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        modifier.accept(map);
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
    }
}

