/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class EntityUtils {
    private EntityUtils() {
        throw new AssertionError();
    }

    public static HitResult raycastNoFluid(Entity entity, double maxDistance) {
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20236_(entity.m_20089_()), entity.m_20189_());
        return entity.m_20193_().m_45547_(new ClipContext(origin, origin.m_82549_(entity.m_20154_().m_82541_().m_82490_(maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }

    public static Set<Entity> getEntitiesLookedAt(Entity looker, double maxDistance) {
        return EntityUtils.getEntityLookedAtHelper((Entity)looker, (double)maxDistance).all;
    }

    public static Entity getEntityLookedAt(Entity looker, double maxDistance) {
        return EntityUtils.getEntityLookedAtHelper((Entity)looker, (double)maxDistance).main;
    }

    private static LookedAtEntities getEntityLookedAtHelper(Entity looker, double maxDistance) {
        HitResult hitResult = EntityUtils.raycastNoFluid(looker, maxDistance);
        Vec3 lookerPosition = looker.m_20182_().m_82520_(0.0, (double)looker.m_20236_(looker.m_20089_()), 0.0);
        double distance = hitResult == null ? maxDistance : hitResult.m_82450_().m_82554_(lookerPosition);
        Vec3 length = new Vec3(looker.m_20154_().f_82479_ * maxDistance, looker.m_20154_().f_82480_ * maxDistance, looker.m_20154_().f_82481_ * maxDistance);
        Vec3 end = lookerPosition.m_82549_(length);
        Entity selectedEntity = null;
        Entity foundEntity = null;
        HashSet<Entity> foundEntities = new HashSet<Entity>();
        double distanceToSelected = distance;
        for (Entity entity : looker.m_20193_().m_45933_(looker, looker.m_142469_().m_82369_(length).m_82400_(1.0))) {
            if (entity.m_6087_()) {
                double currDist;
                AABB collisionBox = entity.m_6921_();
                Optional intercept = collisionBox.m_82371_(lookerPosition, end);
                if (collisionBox.m_82390_(lookerPosition)) {
                    if (distanceToSelected >= 0.0) {
                        selectedEntity = entity;
                        distanceToSelected = 0.0;
                    }
                } else if (intercept.isPresent() && ((currDist = lookerPosition.m_82554_((Vec3)intercept.get())) < distanceToSelected || distanceToSelected == 0.0)) {
                    selectedEntity = entity;
                    distanceToSelected = currDist;
                }
            }
            if (selectedEntity == null || !(distanceToSelected < distance) && hitResult != null) continue;
            foundEntity = selectedEntity;
            foundEntities.add(selectedEntity);
        }
        return new LookedAtEntities(foundEntity, foundEntities);
    }

    public static Vec2 getFacingAngle(Entity entity, Vec3 location) {
        Vec3 vec3d = entity.m_20182_();
        double d = location.f_82479_ - vec3d.f_82479_;
        double e = location.f_82480_ - vec3d.f_82480_;
        double f = location.f_82481_ - vec3d.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        float h = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)e, (double)g) * 57.2957763671875))));
        float i = Mth.m_14177_((float)((float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f));
        return new Vec2(h, i);
    }

    private record LookedAtEntities(Entity main, Set<Entity> all) {
    }
}

