/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.flytre.flytre_lib.api.base.util.TagUtils;
import net.flytre.flytre_lib.mixin.base.AbstractBlockAccessor;
import net.flytre.flytre_lib.mixin.base.MiningToolItemAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class ItemUtils {
    public static final Random RANDOM = new Random();

    private ItemUtils() {
        throw new AssertionError();
    }

    public static float getHardness(ItemStack stack) {
        assert (stack.m_41720_() instanceof BlockItem);
        return ((BlockItem)stack.m_41720_()).m_40614_().m_155943_();
    }

    public static float getResistance(ItemStack stack) {
        assert (stack.m_41720_() instanceof BlockItem);
        return ((AbstractBlockAccessor)((BlockItem)stack.m_41720_()).m_40614_()).getResistance();
    }

    public static boolean getFlammable(ItemStack stack) {
        assert (stack.m_41720_() instanceof BlockItem);
        return ((AbstractBlockAccessor)((BlockItem)stack.m_41720_()).m_40614_()).getMaterial().m_76335_();
    }

    public static double getAttributeValue(ItemStack stack, Attribute attribute) {
        EquipmentSlot slot = stack.m_41720_() instanceof ArmorItem ? ((ArmorItem)stack.m_41720_()).m_40402_() : EquipmentSlot.MAINHAND;
        return ItemUtils.getAttributeValue(stack, attribute, slot);
    }

    public static double getAttributeValue(ItemStack stack, Attribute attribute, EquipmentSlot slot) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        assert (player != null);
        return ItemUtils.getAttributeValue(stack, attribute, slot, (Player)player);
    }

    public static double getAttributeValue(ItemStack stack, Attribute attribute, EquipmentSlot slot, Player player) {
        double d = player.m_21172_(attribute);
        Multimap multimap = stack.m_41638_(slot);
        Map<AttributeModifier.Operation, Collection<AttributeModifier>> map = ItemUtils.genModifierOperationMap((Multimap<Attribute, AttributeModifier>)multimap, attribute);
        for (AttributeModifier modifier : map.get(AttributeModifier.Operation.ADDITION)) {
            d += modifier.m_22218_();
        }
        double e = d;
        for (AttributeModifier modifier : map.get(AttributeModifier.Operation.MULTIPLY_BASE)) {
            e += d * modifier.m_22218_();
        }
        for (AttributeModifier modifier : map.get(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            e *= 1.0 + modifier.m_22218_();
        }
        return attribute.m_6740_(e);
    }

    private static Map<AttributeModifier.Operation, Collection<AttributeModifier>> genModifierOperationMap(Multimap<Attribute, AttributeModifier> multimap, Attribute attribute) {
        HashMap<AttributeModifier.Operation, Collection<AttributeModifier>> result = new HashMap<AttributeModifier.Operation, Collection<AttributeModifier>>();
        for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
            result.put(op, new HashSet());
        }
        for (AttributeModifier modifier : multimap.get((Object)attribute)) {
            ((Collection)result.get(modifier.m_22217_())).add(modifier);
        }
        return result;
    }

    public static boolean hasAttribute(ItemStack stack, Attribute attribute) {
        EquipmentSlot slot = stack.m_41720_() instanceof ArmorItem ? ((ArmorItem)stack.m_41720_()).m_40402_() : EquipmentSlot.MAINHAND;
        return stack.m_41638_(slot).get((Object)attribute).size() > 0;
    }

    public static int getHarvestLevel(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof TieredItem ? ((TieredItem)item).m_43314_().m_6604_() : -1;
    }

    public static double getHarvestSpeed(ItemStack stack) {
        BlockState state = ItemUtils.getBlockForTool(stack);
        if (state == Blocks.f_50016_.m_49966_()) {
            return -1.0;
        }
        return stack.m_41720_().m_8102_(stack, state);
    }

    public static BlockState getBlockForTool(ItemStack stack) {
        if (stack.m_41720_() instanceof DiggerItem) {
            List<Block> blocks = TagUtils.getKeyValuesAsList(Registry.f_122824_, ((MiningToolItemAccessor)stack.m_41720_()).getEffectiveBlocks());
            return blocks.get((int)(Math.random() * (double)blocks.size())).m_49966_();
        }
        if (stack.m_41720_() instanceof ShearsItem) {
            return Blocks.f_50033_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static Optional<Integer> getLuminance(Item item) {
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        Block block = ((BlockItem)item).m_40614_();
        BlockState def = block.m_49966_();
        if (def.m_61147_().contains(BlockStateProperties.f_61443_)) {
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true));
        }
        return def.m_60791_() > 0 ? Optional.of(def.m_60791_()) : Optional.empty();
    }
}

