/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class JsonNbtConverter {
    private JsonNbtConverter() {
        throw new AssertionError();
    }

    public static Tag toNbt(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isBoolean()) {
                return ByteTag.m_128273_((boolean)primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                if (number instanceof Byte) {
                    return ByteTag.m_128266_((byte)number.byteValue());
                }
                if (number instanceof Short) {
                    return ShortTag.m_129258_((short)number.shortValue());
                }
                if (number instanceof Integer) {
                    return IntTag.m_128679_((int)number.intValue());
                }
                if (number instanceof Long) {
                    return LongTag.m_128882_((long)number.longValue());
                }
                if (number instanceof Float) {
                    return FloatTag.m_128566_((float)number.floatValue());
                }
                if (number instanceof Double) {
                    return DoubleTag.m_128500_((double)number.doubleValue());
                }
                if (number instanceof LazilyParsedNumber) {
                    double val = number.doubleValue();
                    if (Math.abs(val - Math.floor(val)) < 0.001) {
                        return IntTag.m_128679_((int)((int)Math.round(val)));
                    }
                    return DoubleTag.m_128500_((double)val);
                }
            } else if (primitive.isString()) {
                return StringTag.m_129297_((String)primitive.getAsString());
            }
        } else {
            if (json instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)json;
                ListTag list = new ListTag();
                for (JsonElement element : jsonArray) {
                    list.add((Object)JsonNbtConverter.toNbt(element));
                }
                return list;
            }
            if (json instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)json;
                CompoundTag compound = new CompoundTag();
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    compound.m_128365_((String)jsonEntry.getKey(), JsonNbtConverter.toNbt((JsonElement)jsonEntry.getValue()));
                }
                return compound;
            }
            if (json instanceof JsonNull) {
                throw new AssertionError((Object)"Null elements not supported.");
            }
        }
        throw new AssertionError((Object)"JSON to NBT failed.");
    }

    public static JsonElement toJson(Tag nbtElement) {
        return JsonNbtConverter.toJson(nbtElement, ConversionMode.RAW);
    }

    public static JsonElement toJson(Tag element, ConversionMode mode) {
        if (element instanceof NumericTag) {
            NumericTag nbtNumber = (NumericTag)element;
            switch (mode) {
                case JSON: {
                    if (nbtNumber instanceof ByteTag) {
                        ByteTag nbtByte = (ByteTag)nbtNumber;
                        byte value = nbtByte.m_7063_();
                        switch (value) {
                            case 0: {
                                return new JsonPrimitive(Boolean.valueOf(false));
                            }
                            case 1: {
                                return new JsonPrimitive(Boolean.valueOf(true));
                            }
                        }
                    }
                }
                case RAW: {
                    return new JsonPrimitive(nbtNumber.m_8103_());
                }
            }
        } else {
            if (element instanceof StringTag) {
                return new JsonPrimitive(element.m_7916_());
            }
            if (element instanceof ListTag) {
                ListTag list = (ListTag)element;
                JsonArray jsonArray = new JsonArray();
                for (Tag tag : list) {
                    jsonArray.add(JsonNbtConverter.toJson(tag, mode));
                }
                return jsonArray;
            }
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                JsonObject jsonObject = new JsonObject();
                for (String key : compound.m_128431_()) {
                    jsonObject.add(key, JsonNbtConverter.toJson(compound.m_128423_(key), mode));
                }
                return jsonObject;
            }
            if (element instanceof EndTag) {
                throw new AssertionError((Object)"Should not encounter end tag");
            }
        }
        throw new UnsupportedOperationException("Unsupported nbt tag type");
    }

    public static enum ConversionMode {
        RAW,
        JSON;

    }
}

