/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.flytre.flytre_lib.impl.base.PacketUtilsImpl;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public final class PacketUtils {
    public static <P extends Packet<ClientGamePacketListener>> void registerS2CPacket(Class<P> type, Function<FriendlyByteBuf, P> function) {
        PacketUtilsImpl.registerS2CPacket(type, function);
    }

    public static <P extends Packet<ServerGamePacketListener>> void registerC2SPacket(Class<P> type, Function<FriendlyByteBuf, P> function) {
        PacketUtilsImpl.registerC2SPacket(type, function);
    }

    public static <T> void toPacket(FriendlyByteBuf buf, List<T> list, BiConsumer<T, FriendlyByteBuf> func) {
        PacketUtilsImpl.toPacket(buf, list, func);
    }

    public static <T> void toPacket(FriendlyByteBuf buf, Set<T> set, BiConsumer<T, FriendlyByteBuf> func) {
        PacketUtilsImpl.toPacket(buf, set, func);
    }

    public static <T, K> void toPacket(FriendlyByteBuf buf, Map<T, K> map, BiConsumer<T, FriendlyByteBuf> keyToPacket, BiConsumer<K, FriendlyByteBuf> valToPacket) {
        PacketUtilsImpl.toPacket(buf, map, keyToPacket, valToPacket);
    }

    public static <T> List<T> listFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> func) {
        return PacketUtilsImpl.listFromPacket(buf, func);
    }

    public static <T> Set<T> setFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> func) {
        return PacketUtilsImpl.setFromPacket(buf, func);
    }

    public static <T, K> Map<T, K> mapFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> packetToKey, Function<FriendlyByteBuf, K> packetToVal) {
        return PacketUtilsImpl.mapFromPacket(buf, packetToKey, packetToVal);
    }

    private PacketUtils() {
        throw new AssertionError();
    }
}

