/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class ParticleUtils {
    private ParticleUtils() {
        throw new AssertionError();
    }

    public static void drawLineTo(Vec3 a, Vec3 b, ParticleOptions particle, ServerLevel world) {
        ParticleUtils.drawLineTo(a, b, particle, world, 1, true);
    }

    public static void drawLineTo(Vec3 a, Vec3 b, ParticleOptions particle, ServerLevel world, int count, boolean force) {
        double dist = a.m_82554_(b);
        Collection<ServerPlayer> players = ParticleUtils.tracking(world, new BlockPos(a.f_82479_, a.f_82480_, a.f_82481_));
        players.addAll(ParticleUtils.tracking(world, new BlockPos(b.f_82479_, b.f_82480_, b.f_82481_)));
        for (double i = 0.0; i < 1.0; i += Math.min(0.1, 1.0 / (dist * 2.0))) {
            double x = a.m_7096_() + (b.m_7096_() - a.m_7096_()) * i;
            double y = a.m_7098_() + 1.0 + (b.m_7098_() - a.m_7098_()) * i;
            double z = a.m_7094_() + 1.0 + (b.m_7094_() - a.m_7094_()) * i;
            for (ServerPlayer playerEntity : players) {
                world.m_8624_(playerEntity, particle, force, x, y, z, count, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        return world.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false);
    }

    public static Vec3 caretToAbsolute(Vec3 caretValues, Vec2 rotation, Vec3 anchorPosition) {
        float f = Mth.m_14089_((float)((rotation.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float g = Mth.m_14031_((float)((rotation.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(-rotation.f_82470_ * ((float)Math.PI / 180)));
        float i = Mth.m_14031_((float)(-rotation.f_82470_ * ((float)Math.PI / 180)));
        float j = Mth.m_14089_((float)((-rotation.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)((-rotation.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec3d2 = new Vec3((double)(f * h), (double)i, (double)(g * h));
        Vec3 vec3d3 = new Vec3((double)(f * j), (double)k, (double)(g * j));
        Vec3 vec3d4 = vec3d2.m_82537_(vec3d3).m_82490_(-1.0);
        double d = vec3d2.f_82479_ * caretValues.f_82481_ + vec3d3.f_82479_ * caretValues.f_82480_ + vec3d4.f_82479_ * caretValues.f_82479_;
        double e = vec3d2.f_82480_ * caretValues.f_82481_ + vec3d3.f_82480_ * caretValues.f_82480_ + vec3d4.f_82480_ * caretValues.f_82479_;
        double l = vec3d2.f_82481_ * caretValues.f_82481_ + vec3d3.f_82481_ * caretValues.f_82480_ + vec3d4.f_82481_ * caretValues.f_82479_;
        return new Vec3(anchorPosition.f_82479_ + d, anchorPosition.f_82480_ + e, anchorPosition.f_82481_ + l);
    }
}

