/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.api.base.util.FakeWorld;
import net.flytre.flytre_lib.impl.base.RenderUtilsImpl;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static int color(Level world, BlockPos pos, Fluid fluid) {
        return RenderUtilsImpl.getColor(world, pos, fluid);
    }

    public static TextureAtlasSprite textureName(Level world, BlockPos pos, Fluid fluid) {
        return RenderUtilsImpl.getSprite(world, pos, fluid);
    }

    public static void renderFluidInGui(PoseStack matrixStack, Fluid fluid, int drawHeight, int x, int y, int width, int height) {
        RenderUtilsImpl.renderFluidInGui(matrixStack, fluid, drawHeight, x, y, width, height);
    }

    public static void drawBorderedRect(Rectangle rectangle, int hex, int borderHex, int borderThickness) {
        RenderUtils.drawRectangle(rectangle.reducedBy(borderThickness), hex);
        RenderUtils.drawHollowRect(rectangle, borderHex, borderThickness);
    }

    public static void drawBorderAround(Rectangle rectangle, int hex, int thickness) {
        Rectangle modified = new Rectangle(rectangle.getLeft() - thickness, rectangle.getTop() - thickness, rectangle.getWidth() + thickness * 2, rectangle.getHeight() + thickness * 2);
        RenderUtils.drawHollowRect(modified, hex, thickness);
    }

    public static void drawHollowRect(Rectangle rectangle, int hex, int thickness) {
        Rectangle top = new Rectangle(rectangle.getLeft(), rectangle.getTop(), rectangle.getWidth(), thickness);
        Rectangle bottom = new Rectangle(rectangle.getLeft(), rectangle.getBottom() - thickness, rectangle.getWidth(), thickness);
        Rectangle left = new Rectangle(rectangle.getLeft(), rectangle.getTop() + thickness, thickness, rectangle.getHeight() - thickness * 2);
        Rectangle right = new Rectangle(rectangle.getRight() - thickness, rectangle.getTop() + thickness, thickness, rectangle.getHeight() - thickness * 2);
        RenderUtils.drawRectangle(top, hex);
        RenderUtils.drawRectangle(bottom, hex);
        RenderUtils.drawRectangle(left, hex);
        RenderUtils.drawRectangle(right, hex);
    }

    public static void drawRectangle(Rectangle rectangle, int hex) {
        Color color = new Color(hex);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)rectangle.getLeft(), (double)rectangle.getBottom(), 0.0).m_85950_(color.red, color.green, color.blue, color.alpha).m_5752_();
        buffer.m_5483_((double)rectangle.getRight(), (double)rectangle.getBottom(), 0.0).m_85950_(color.red, color.green, color.blue, color.alpha).m_5752_();
        buffer.m_5483_((double)rectangle.getRight(), (double)rectangle.getTop(), 0.0).m_85950_(color.red, color.green, color.blue, color.alpha).m_5752_();
        buffer.m_5483_((double)rectangle.getLeft(), (double)rectangle.getTop(), 0.0).m_85950_(color.red, color.green, color.blue, color.alpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        RenderUtils.drawRectangle(Rectangle.fromBounds(left, top, right, bottom), color);
    }

    public static int[] unpackColor(int color) {
        int[] colors = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    public static void renderBlockSprite(VertexConsumer builder, PoseStack stack, TextureAtlasSprite sprite, int light, int overlay, int[] color) {
        RenderUtils.renderBlockSprite(builder, stack.m_85850_().m_85861_(), sprite, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    public static void renderBlockSprite(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.DOWN, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.UP, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.NORTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.SOUTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.WEST, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.EAST, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    public static void renderSpriteSide(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, Direction side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        float v2;
        float v1;
        float u2;
        float u1;
        double px1 = x1 * 16.0f;
        double px2 = x2 * 16.0f;
        double py1 = y1 * 16.0f;
        double py2 = y2 * 16.0f;
        double pz1 = z1 * 16.0f;
        double pz2 = z2 * 16.0f;
        if (side == Direction.DOWN) {
            u1 = sprite.m_118367_(px1);
            u2 = sprite.m_118367_(px2);
            v1 = sprite.m_118393_(pz1);
            v2 = sprite.m_118393_(pz2);
            builder.m_85982_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (side == Direction.UP) {
            u1 = sprite.m_118367_(px1);
            u2 = sprite.m_118367_(px2);
            v1 = sprite.m_118393_(pz1);
            v2 = sprite.m_118393_(pz2);
            builder.m_85982_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (side == Direction.NORTH) {
            u1 = sprite.m_118367_(px1);
            u2 = sprite.m_118367_(px2);
            v1 = sprite.m_118393_(py1);
            v2 = sprite.m_118393_(py2);
            builder.m_85982_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_85982_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (side == Direction.SOUTH) {
            u1 = sprite.m_118367_(px1);
            u2 = sprite.m_118367_(px2);
            v1 = sprite.m_118393_(py1);
            v2 = sprite.m_118393_(py2);
            builder.m_85982_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_85982_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (side == Direction.WEST) {
            u1 = sprite.m_118367_(py1);
            u2 = sprite.m_118367_(py2);
            v1 = sprite.m_118393_(pz1);
            v2 = sprite.m_118393_(pz2);
            builder.m_85982_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (side == Direction.EAST) {
            u1 = sprite.m_118367_(py1);
            u2 = sprite.m_118367_(py2);
            v1 = sprite.m_118393_(pz1);
            v2 = sprite.m_118393_(pz2);
            builder.m_85982_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    public static void render(ResourceLocation id, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110494_((ResourceLocation)id));
        List<ModelPart.Cube> cuboids = List.of(new ModelPart.Cube(0, 0, -0.01f, -0.01f, -0.01f, 16.02f, 16.02f, 16.02f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
        ModelPart model = new ModelPart(cuboids, new HashMap());
        model.m_104301_(matrices, vertexConsumer, light, overlay);
        matrices.m_85849_();
    }

    public static void renderSide(ResourceLocation id, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, Direction dir) {
        matrices.m_85836_();
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110494_((ResourceLocation)id));
        List<ModelPart.Cube> cuboids = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.WEST -> List.of(new ModelPart.Cube(0, 0, -0.01f, -0.01f, -0.01f, 0.0f, 16.02f, 16.02f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
            case Direction.EAST -> List.of(new ModelPart.Cube(0, 0, 16.01f, -0.01f, -0.01f, 0.0f, 16.02f, 16.02f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
            case Direction.NORTH -> List.of(new ModelPart.Cube(0, 0, -0.01f, -0.01f, -0.01f, 16.02f, 16.02f, 0.0f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
            case Direction.SOUTH -> List.of(new ModelPart.Cube(0, 0, -0.01f, -0.01f, 16.01f, 16.02f, 16.02f, 0.0f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
            case Direction.UP -> List.of(new ModelPart.Cube(0, 0, -0.01f, 16.01f, -0.01f, 16.02f, 0.0f, 16.02f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
            case Direction.DOWN -> List.of(new ModelPart.Cube(0, 0, -0.01f, -0.01f, -0.01f, 16.02f, 0.0f, 16.02f, 0.0f, 0.0f, 0.0f, false, 16.0f, 16.0f));
        };
        ModelPart model = new ModelPart(cuboids, new HashMap());
        model.m_104301_(matrices, vertexConsumer, light, overlay);
        matrices.m_85849_();
    }

    public static void renderSpinningEntity(int x, int y, int size, float mouseX, float mouseY, Entity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 1050.0);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.m_85837_(0.0, 0.0, 1000.0);
        matrixStack2.m_85841_((float)size, (float)size, (float)size);
        float scalar = (float)(1.0 / entity.m_142469_().m_82376_());
        if (scalar < 1.0f) {
            scalar = (float)(2.0 / entity.m_142469_().m_82376_());
        }
        matrixStack2.m_85841_(scalar, scalar, scalar);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion2 = Vector3f.f_122223_.m_122240_(g * 20.0f);
        quaternion.m_80148_(quaternion2);
        matrixStack2.m_85845_(quaternion);
        float h = entity instanceof LivingEntity ? ((LivingEntity)entity).f_20883_ : 0.0f;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity instanceof LivingEntity ? ((LivingEntity)entity).f_20886_ : 0.0f;
        float l = entity instanceof LivingEntity ? ((LivingEntity)entity).f_20885_ : 0.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20883_ = 180.0f + f * 20.0f;
            ((LivingEntity)entity).f_20885_ = entity.m_146908_();
            ((LivingEntity)entity).f_20886_ = entity.m_146908_();
        }
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        entityRenderDispatcher.m_114408_((Level)FakeWorld.getInstance(), new Camera(), null);
        Quaternion rotation = Vector3f.f_122225_.m_122240_((float)(System.currentTimeMillis() % 3600L) / 10.0f);
        matrixStack2.m_85845_(rotation);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        immediate.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20883_ = h;
            ((LivingEntity)entity).f_20886_ = k;
            ((LivingEntity)entity).f_20885_ = l;
        }
        entity.m_146922_(i);
        entity.m_146926_(j);
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public static void renderSpinningItem(ItemStack stack, int x, int y, BakedModel model) {
        boolean bl;
        Minecraft client = Minecraft.m_91087_();
        assert (client != null);
        TextureManager textureManager = client.m_91097_();
        ItemRenderer renderer = client.m_91291_();
        textureManager.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, (double)(100.0f + renderer.f_115093_));
        matrixStack.m_85837_(8.0, 8.0, 0.0);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack2 = new PoseStack();
        Quaternion rotation = Vector3f.f_122225_.m_122240_((float)(System.currentTimeMillis() % 3600L) / 10.0f);
        matrixStack2.m_85845_(rotation);
        matrixStack2.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl2 = bl = !model.m_7547_();
        if (bl) {
            Lighting.m_84930_();
        }
        assert (client.f_91073_ != null);
        renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, matrixStack2, (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
        immediate.m_109911_();
        RenderSystem.m_69482_();
        if (bl) {
            Lighting.m_84931_();
        }
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static int drawWrappedString(PoseStack matrices, String string, int x, int y, int wrapWidth, int maxLines, int color) {
        int i;
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        Minecraft client = Minecraft.m_91087_();
        List strings = client.f_91062_.m_92865_().m_92414_((FormattedText)new TextComponent(string), wrapWidth, Style.f_131099_);
        for (i = 0; i < strings.size() && i < maxLines; ++i) {
            FormattedText renderable = (FormattedText)strings.get(i);
            if (i == maxLines - 1 && strings.size() > maxLines) {
                renderable = FormattedText.m_130773_((FormattedText[])new FormattedText[]{(FormattedText)strings.get(i), FormattedText.m_130775_((String)"...")});
            }
            FormattedCharSequence line = Language.m_128107_().m_5536_(renderable);
            int x1 = x;
            if (client.f_91062_.m_92718_()) {
                int width = client.f_91062_.m_92724_(line);
                x1 = (int)((float)x1 + (float)(wrapWidth - width));
            }
            Font font = client.f_91062_;
            float f = x1;
            Objects.requireNonNull(client.f_91062_);
            font.m_92877_(matrices, line, f, (float)(y + i * 9), color);
        }
        Objects.requireNonNull(client.f_91062_);
        return i * 9;
    }

    public static int getWrappedHeight(String string, int wrapWidth, int maxLines) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        Minecraft client = Minecraft.m_91087_();
        List strings = client.f_91062_.m_92865_().m_92414_((FormattedText)new TextComponent(string), wrapWidth, Style.f_131099_);
        int n = Math.min(strings.size(), maxLines);
        Objects.requireNonNull(client.f_91062_);
        return n * 9;
    }

    public static void drawColorWheel(int centerX, int centerY, double radius, float brightness, float alpha) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69464_();
        ColoredCoordinate center = new ColoredCoordinate(centerX, centerY, new java.awt.Color(java.awt.Color.HSBtoRGB(0.0f, 0.0f, brightness)));
        LinkedList<ColoredCoordinate> vertices = new LinkedList<ColoredCoordinate>();
        for (int degrees = 360; degrees >= 0; degrees -= 10) {
            double radians = (double)degrees * Math.PI / 180.0;
            double x = radius * Math.cos(radians);
            double y = radius * Math.sin(radians);
            vertices.add(new ColoredCoordinate(x + center.x, y + center.y, new java.awt.Color(java.awt.Color.HSBtoRGB((float)degrees / 360.0f, 1.0f, brightness))));
        }
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(center.x, center.y, 0.0).m_6122_(center.color.getRed(), center.color.getGreen(), center.color.getBlue(), (int)(alpha * 255.0f)).m_5752_();
        while (!vertices.isEmpty()) {
            ColoredCoordinate coord = (ColoredCoordinate)vertices.poll();
            buffer.m_5483_(coord.x, coord.y, 0.0).m_6122_(coord.color.getRed(), coord.color.getGreen(), coord.color.getBlue(), (int)(alpha * 255.0f)).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        RenderSystem.m_69481_();
    }

    public static int getPixelColor(int x, int y) {
        Minecraft client = Minecraft.m_91087_();
        RenderTarget framebuffer = client.m_91385_();
        int width = framebuffer.f_83915_;
        int height = framebuffer.f_83916_;
        int channels = 4;
        long sizeBytes = (long)width * (long)height * (long)channels;
        long pointer = MemoryUtil.nmemAlloc((long)sizeBytes);
        RenderSystem.m_69396_((int)framebuffer.m_83975_());
        RenderSystem.m_187554_();
        GlStateManager.m_84522_((int)3333, (int)4);
        int pixelDataFormat = 6408;
        int level = 0;
        GlStateManager.m_84227_((int)3553, (int)level, (int)pixelDataFormat, (int)5121, (long)pointer);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            int j = width * channels;
            long l = memoryStack.nmalloc(j);
            for (int k = 0; k < height / 2; ++k) {
                int m = k * width * channels;
                int n = (height - 1 - k) * width * channels;
                MemoryUtil.memCopy((long)(pointer + (long)m), (long)l, (long)j);
                MemoryUtil.memCopy((long)(pointer + (long)n), (long)(pointer + (long)m), (long)j);
                MemoryUtil.memCopy((long)l, (long)(pointer + (long)n), (long)j);
            }
        }
        long l = ((long)x + (long)y * (long)width) * 4L;
        int color = MemoryUtil.memGetInt((long)(pointer + l));
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return b * 65536 + g * 256 + r;
    }

    public static int getModernUiColor(boolean active, boolean hovered) {
        if (!active) {
            return 0x440A0A0A;
        }
        if (hovered) {
            return -2006226069;
        }
        return 0x446B6B6B;
    }

    private record Color(float red, float green, float blue, float alpha) {
        public Color(int color) {
            this((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
        }
    }

    private record ColoredCoordinate(double x, double y, java.awt.Color color) {
    }
}

