/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class TagUtils {
    private TagUtils() {
        throw new AssertionError();
    }

    public static <T> List<T> getKeyValuesAsList(@NotNull RegistryAccess manager, TagKey<T> tagKey) {
        return TagUtils.getKeyValuesAsList(manager.m_175515_(tagKey.f_203867_()), tagKey);
    }

    public static <T> Set<T> getKeyValuesAsSet(@NotNull RegistryAccess manager, TagKey<T> tagKey) {
        return TagUtils.getKeyValuesAsSet(manager.m_175515_(tagKey.f_203867_()), tagKey);
    }

    private static <T> Stream<T> getKeyValues(Registry<T> registry, TagKey<T> tagKey) {
        Optional entries = registry.m_203431_(tagKey);
        if (entries.isEmpty()) {
            throw new AssertionError((Object)("Registry Entry List not found for Tag Key " + tagKey.f_203868_()));
        }
        HolderSet.Named named = (HolderSet.Named)entries.get();
        return named.m_203614_().map(Holder::m_203334_);
    }

    public static <T> List<T> getKeyValuesAsList(Registry<T> registry, TagKey<T> tagKey) {
        return TagUtils.getKeyValues(registry, tagKey).toList();
    }

    public static <T> Set<T> getKeyValuesAsSet(Registry<T> registry, TagKey<T> tagKey) {
        return TagUtils.getKeyValues(registry, tagKey).collect(Collectors.toSet());
    }
}

