/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util.reflection;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.flytre.flytre_lib.api.base.util.reflection.FieldMatch;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        do {
            result.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return result;
    }

    @Nullable
    public static FieldMatch match(Collection<Field> fields, String serializedName) {
        for (Field field : fields) {
            SerializedName nameAnnotation;
            if (Modifier.isTransient(field.getModifiers()) || ((nameAnnotation = field.getAnnotation(SerializedName.class)) == null || !nameAnnotation.value().equals(serializedName)) && (nameAnnotation != null || !field.getName().equals(serializedName))) continue;
            String key = nameAnnotation != null ? nameAnnotation.value() : field.getName();
            return new FieldMatch(field, key);
        }
        return null;
    }

    private ReflectionUtils() {
        throw new AssertionError();
    }
}

