/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.flytre.flytre_lib.FlytreLibConstants;
import net.flytre.flytre_lib.api.base.util.reflection.FieldMatch;
import net.flytre.flytre_lib.api.base.util.reflection.ReflectionUtils;
import net.flytre.flytre_lib.api.config.ConfigEventAcceptor;
import net.flytre.flytre_lib.api.config.GsonHelper;
import net.flytre.flytre_lib.api.config.annotation.Description;
import net.flytre.flytre_lib.api.config.annotation.Range;
import net.flytre.flytre_lib.impl.config.ConfigHelper;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public final class ConfigHandler<T> {
    private final Gson gson;
    private final T assumed;
    private final String name;
    private final String translationPrefix;
    private T config;

    public ConfigHandler(T assumed, String name) {
        this(assumed, name, (String)null);
    }

    public ConfigHandler(T assumed, String name, Gson gson) {
        this(assumed, name, null, gson);
    }

    public ConfigHandler(T assumed, String name, String translationPrefix) {
        this(assumed, name, translationPrefix, GsonHelper.GSON);
    }

    public ConfigHandler(T assumed, String name, String translationPrefix, Gson gson) {
        this.gson = gson;
        this.assumed = assumed;
        this.name = name;
        this.translationPrefix = translationPrefix;
    }

    public String getTranslationPrefix() {
        return this.translationPrefix;
    }

    public String getName() {
        return this.name;
    }

    public void save(T config) {
        Path base = LoaderProperties.getModConfigDirectory();
        Path loc = Paths.get(base.toString(), this.name + ".json5");
        this.save(config, new File(loc.toString()));
    }

    public void save(T config, File file) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(file);
            JsonElement parsed = this.commentFormattedGson(this.gson.toJsonTree(config), config);
            writer.write(StringEscapeUtils.unescapeJava((String)this.formattedGsonToJson5(this.gson.toJson(parsed))));
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String formattedGsonToJson5(String str) {
        Pattern commentPattern = Pattern.compile("([ \\t]*)\"(\\w*)\":\\s*\\{\\s*\"value\": (.+?),\\s*\"comment\": \"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"\\s*}", 32);
        Matcher m = commentPattern.matcher((CharSequence)str);
        while (m.find()) {
            str = commentPattern.matcher((CharSequence)str).replaceAll("$1//$4\\\n$1\"$2\": $3");
            m = commentPattern.matcher((CharSequence)str);
        }
        Pattern multiline = Pattern.compile("^(\\s*)//(.*?)\\\\n(.*)$", 8);
        while (((String)str).contains("\\n")) {
            str = multiline.matcher((CharSequence)str).replaceAll("$1//$2\n$1//$3");
        }
        str = "//Hit F3 + M to edit configs client side in game\n" + (String)str;
        return str;
    }

    private JsonElement commentFormattedGson(JsonElement serialized, T config) {
        if (!(serialized instanceof JsonObject)) {
            return serialized;
        }
        JsonObject object = (JsonObject)serialized;
        this.commentFormattedGsonHelper(object, config.getClass());
        return object;
    }

    private void commentFormattedGsonHelper(JsonObject object, Class<?> clazz) {
        List<Field> fields = ReflectionUtils.getFields(clazz);
        for (Map.Entry entry : object.entrySet()) {
            Range range;
            FieldMatch fieldMatch = ReflectionUtils.match(fields, (String)entry.getKey());
            if (fieldMatch == null) continue;
            Object comment = "";
            Description description = fieldMatch.field().getAnnotation(Description.class);
            if (description != null) {
                comment = (String)comment + description.value();
            }
            if (fieldMatch.field().getType().isEnum()) {
                comment = (String)comment + (((String)comment).length() > 0 ? " " : "") + ConfigHelper.enumAsStringArray(fieldMatch.field().getType());
            }
            if ((range = fieldMatch.field().getAnnotation(Range.class)) != null) {
                comment = (String)comment + (((String)comment).length() > 0 ? " " : "") + ConfigHelper.asString(range);
            }
            if (entry.getValue() instanceof JsonObject) {
                this.commentFormattedGsonHelper((JsonObject)entry.getValue(), fieldMatch.field().getType());
            }
            if (((String)comment).length() <= 0) continue;
            JsonObject o = new JsonObject();
            o.add("value", (JsonElement)entry.getValue());
            o.addProperty("comment", (String)comment);
            object.add((String)entry.getKey(), (JsonElement)o);
        }
    }

    private void validate(JsonObject serialized, T config) throws IllegalAccessException {
        this.validate(serialized, config.getClass(), config, new ArrayList<String>());
    }

    private void validate(JsonObject json, Class<?> clazz, Object obj, List<String> path) throws IllegalAccessException {
        List<Field> fields = ReflectionUtils.getFields(clazz);
        for (Map.Entry entry : json.entrySet()) {
            FieldMatch fieldMatch = ReflectionUtils.match(fields, (String)entry.getKey());
            if (fieldMatch == null) continue;
            fieldMatch.field().setAccessible(true);
            Object value = fieldMatch.field().get(obj);
            if (value == null) {
                throw new ValidationException("Null value found for field " + fieldMatch.field().getName() + ". Likely caused by an invalid value for said field");
            }
            Range range = fieldMatch.field().getAnnotation(Range.class);
            if (range != null) {
                if (range.max() < range.min()) {
                    throw new ConfigAnnotationException("Invalid @Range annotation for field " + fieldMatch.field().getName() + ": Max value must be less or equal to the min value");
                }
                if (!(value instanceof Number)) {
                    throw new ConfigAnnotationException("@Range annotation unsupported for field " + fieldMatch.field().getName());
                }
                Number number = (Number)value;
                if (range.min() > number.doubleValue() || range.max() < number.doubleValue()) {
                    ArrayList<String> path2 = new ArrayList<String>(path);
                    path2.add(fieldMatch.field().getName());
                    throw new ValidationException("Value " + value + " for field " + String.join((CharSequence)".", path2) + " is not in range " + ConfigHelper.asString(range));
                }
            }
            if (!(entry.getValue() instanceof JsonObject)) continue;
            fieldMatch.field().setAccessible(true);
            this.validate((JsonObject)entry.getValue(), fieldMatch.field().getType(), fieldMatch.field().get(obj), Stream.concat(path.stream(), Stream.of(fieldMatch.field().getName())).distinct().toList());
        }
    }

    private void appendError(File file, Exception e) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        Object str = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Object errorMessage = e.getMessage();
        if (e instanceof NumberFormatException) {
            errorMessage = "java.lang.NumberFormatException: " + (String)errorMessage;
        }
        errorMessage = ((String)errorMessage).replace("java.lang.NumberFormatException", "Expected a number but found a different data type");
        errorMessage = ((String)errorMessage).replace("java.lang.IllegalStateException", "Wrong type of value passed");
        if (e instanceof ResourceLocationException) {
            errorMessage = (String)errorMessage + ". The namespace is everything before the colon, while the path is everything after";
        }
        errorMessage = (String)errorMessage + ". Default config was loaded.";
        String logLine = "//[" + format.format(date) + "] ERROR: " + (String)errorMessage;
        str = logLine + "\n" + (String)str;
        FileWriter writer = new FileWriter(file);
        writer.write((String)str);
        writer.close();
    }

    public boolean handle() {
        Path base = LoaderProperties.getModConfigDirectory();
        Path loc = Paths.get(base.toString(), this.name + ".json5");
        return this.handle(new File(loc.toString()));
    }

    public boolean handle(File config) {
        boolean error = false;
        if (config == null || !config.exists() || config.length() == 0L) {
            this.save(this.assumed, config);
            this.config = this.assumed;
        } else {
            try (FileReader reader = new FileReader(config);){
                try {
                    JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                    this.config = this.gson.fromJson((JsonElement)json, this.assumed.getClass());
                    this.validate(json, this.config);
                }
                catch (JsonParseException | NumberFormatException | ValidationException | ResourceLocationException e) {
                    this.config = this.assumed;
                    FlytreLibConstants.LOGGER.error("Unable to load config " + this.name + ".json5 : " + e.getMessage() + ". Loading default config instead.");
                    this.appendError(config, (Exception)e);
                    error = true;
                }
            }
            catch (IOException | IllegalAccessException e) {
                e.printStackTrace();
                error = true;
            }
        }
        if (this.config instanceof ConfigEventAcceptor) {
            ((ConfigEventAcceptor)this.config).onReload();
        }
        return !error;
    }

    public T getAssumed() {
        return this.assumed;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(JsonElement element) {
        this.config = this.gson.fromJson(element, this.assumed.getClass());
    }

    public JsonElement getConfigAsJson() {
        return this.gson.toJsonTree(this.config == null ? this.assumed : this.config);
    }

    public ResourceLocation getConfigId() {
        return new ResourceLocation("flytre_lib", this.name);
    }

    public Gson getGson() {
        return this.gson;
    }

    private static class ValidationException
    extends RuntimeException {
        public ValidationException(String msg) {
            super(msg);
        }
    }

    private static class ConfigAnnotationException
    extends RuntimeException {
        public ConfigAnnotationException(String msg) {
            super(msg);
        }
    }
}

