/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.ConfigColor;
import net.flytre.flytre_lib.api.config.reference.AdvancementReference;
import net.flytre.flytre_lib.api.config.reference.AttributeReference;
import net.flytre.flytre_lib.api.config.reference.BiomeReference;
import net.flytre.flytre_lib.api.config.reference.DimensionReference;
import net.flytre.flytre_lib.api.config.reference.EnchantmentReference;
import net.flytre.flytre_lib.api.config.reference.Reference;
import net.flytre.flytre_lib.api.config.reference.SoundEventReference;
import net.flytre.flytre_lib.api.config.reference.StatusEffectReference;
import net.flytre.flytre_lib.api.config.reference.VillagerProfessionReference;
import net.flytre.flytre_lib.api.config.reference.block.BlockReference;
import net.flytre.flytre_lib.api.config.reference.block.BlockTagReference;
import net.flytre.flytre_lib.api.config.reference.block.ConfigBlock;
import net.flytre.flytre_lib.api.config.reference.entity.ConfigEntity;
import net.flytre.flytre_lib.api.config.reference.entity.EntityReference;
import net.flytre.flytre_lib.api.config.reference.entity.EntityTagReference;
import net.flytre.flytre_lib.api.config.reference.fluid.ConfigFluid;
import net.flytre.flytre_lib.api.config.reference.fluid.FluidReference;
import net.flytre.flytre_lib.api.config.reference.fluid.FluidTagReference;
import net.flytre.flytre_lib.api.config.reference.item.ConfigItem;
import net.flytre.flytre_lib.api.config.reference.item.ItemReference;
import net.flytre.flytre_lib.api.config.reference.item.ItemTagReference;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class GsonHelper {
    public static final ResourceLocation.Serializer IDENTIFIER_SERIALIZER = new ResourceLocation.Serializer();
    public static final Map<Class<?>, Registry<?>> REGISTRY_BASED = Map.of(EntityType.class, Registry.f_122826_, Fluid.class, Registry.f_122822_, MobEffect.class, Registry.f_122823_, Block.class, Registry.f_122824_, Enchantment.class, Registry.f_122825_, Item.class, Registry.f_122827_, Attribute.class, Registry.f_122866_, SoundEvent.class, Registry.f_122821_, VillagerProfession.class, Registry.f_122869_);
    public static final GsonBuilder GSON_BUILDER = new GsonHelper().builder;
    public static final Gson GSON = GSON_BUILDER.create();
    private final GsonBuilder builder = new GsonBuilder();
    private final Gson gson;

    public Gson getGson() {
        return this.gson;
    }

    public GsonBuilder getBuilder() {
        return this.builder;
    }

    public GsonHelper() {
        this.builder.setPrettyPrinting();
        this.builder.registerTypeAdapter(ResourceLocation.class, (Object)IDENTIFIER_SERIALIZER);
        this.builder.registerTypeAdapter(new TypeToken<Set<ResourceLocation>>(){}.getType(), new IdentifierBasedSetSerializer(Function.identity(), Function.identity()));
        this.builder.registerTypeAdapter(Set.class, (src, typeOfSrc, context) -> {
            JsonArray array = new JsonArray();
            src.stream().map(arg_0 -> ((JsonSerializationContext)context).serialize(arg_0)).sorted(Comparator.comparing(i -> i.isJsonPrimitive() ? i.getAsString() : "")).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            return array;
        });
        this.builder.registerTypeAdapter(ConfigColor.class, (Object)new ConfigColor.ColorSerializer());
        for (Map.Entry<Class<?>, Registry<?>> entry : REGISTRY_BASED.entrySet()) {
            GsonHelper.registerRegistryBasedClass(entry.getKey(), this.builder, entry.getValue());
        }
        GsonHelper.registerReference(EntityReference.class, this.builder, EntityReference::new);
        GsonHelper.registerReference(FluidReference.class, this.builder, FluidReference::new);
        GsonHelper.registerReference(StatusEffectReference.class, this.builder, StatusEffectReference::new);
        GsonHelper.registerReference(BiomeReference.class, this.builder, BiomeReference::new);
        GsonHelper.registerReference(DimensionReference.class, this.builder, DimensionReference::new);
        GsonHelper.registerReference(BlockReference.class, this.builder, BlockReference::new);
        GsonHelper.registerReference(EnchantmentReference.class, this.builder, EnchantmentReference::new);
        GsonHelper.registerReference(ItemReference.class, this.builder, ItemReference::new);
        GsonHelper.registerReference(AttributeReference.class, this.builder, AttributeReference::new);
        GsonHelper.registerReference(SoundEventReference.class, this.builder, SoundEventReference::new);
        GsonHelper.registerReference(VillagerProfessionReference.class, this.builder, VillagerProfessionReference::new);
        GsonHelper.registerReference(AdvancementReference.class, this.builder, AdvancementReference::new);
        GsonHelper.registerTag(BlockTagReference.class, this.builder, BlockTagReference::new);
        GsonHelper.registerTag(EntityTagReference.class, this.builder, EntityTagReference::new);
        GsonHelper.registerTag(FluidTagReference.class, this.builder, FluidTagReference::new);
        GsonHelper.registerTag(ItemTagReference.class, this.builder, ItemTagReference::new);
        this.builder.registerTypeAdapter(ConfigBlock.class, new ConfigXDeserializer<BlockReference>(BlockTagReference.class, BlockReference.class));
        this.builder.registerTypeAdapter(ConfigEntity.class, new ConfigXDeserializer<EntityReference>(EntityTagReference.class, EntityReference.class));
        this.builder.registerTypeAdapter(ConfigFluid.class, new ConfigXDeserializer<FluidReference>(FluidTagReference.class, FluidReference.class));
        this.builder.registerTypeAdapter(ConfigItem.class, new ConfigXDeserializer<ItemReference>(ItemTagReference.class, ItemReference.class));
        this.gson = this.builder.create();
    }

    public static void registerRegistryBasedClass(Class<?> clazz, GsonBuilder builder, Registry<?> registry) {
        builder.registerTypeAdapter(clazz, new IdentifierBasedSerializer(registry));
        builder.registerTypeAdapter(TypeToken.getParameterized(Set.class, (Type[])new Type[]{clazz}).getType(), new IdentifierBasedSetSerializer(registry));
    }

    public static <T> void registerReference(Class<?> clazz, GsonBuilder builder, Function<ResourceLocation, Reference<T>> toReference) {
        builder.registerTypeAdapter(clazz, new ReferenceSerializer<Reference<T>>(toReference));
        builder.registerTypeAdapter(TypeToken.getParameterized(Set.class, (Type[])new Type[]{clazz}).getType(), new IdentifierBasedSetSerializer<Reference>((Function<ResourceLocation, Reference>)toReference, Reference::getIdentifier));
    }

    public static <T> void registerTag(Class<?> clazz, GsonBuilder builder, Function<ResourceLocation, Reference<T>> toReference) {
        Function<JsonPrimitive, Reference> reference = json -> {
            String str = json.getAsString();
            if (!str.startsWith("#")) {
                throw new JsonParseException("Tried to parse " + str + " as a tag but does not start with #");
            }
            return (Reference)toReference.apply(new ResourceLocation(str.substring(1)));
        };
        Function<Reference, JsonPrimitive> element = ref -> new JsonPrimitive("#" + ref.getIdentifier());
        builder.registerTypeAdapter(clazz, (src, typeOfSrc, context) -> (JsonElement)element.apply((Reference)src));
        builder.registerTypeAdapter(clazz, (json, typeOfT, context) -> (Reference)reference.apply(json.getAsJsonPrimitive()));
        builder.registerTypeAdapter(TypeToken.getParameterized(Set.class, (Type[])new Type[]{clazz}).getType(), new SetSerializer<Reference>(reference, element));
    }

    public static class IdentifierBasedSetSerializer<T>
    extends SetSerializer<T> {
        public IdentifierBasedSetSerializer(Registry<T> registry) {
            this((ResourceLocation i) -> registry.m_6612_(i).orElse(null), arg_0 -> registry.m_7981_(arg_0));
        }

        public IdentifierBasedSetSerializer(Function<ResourceLocation, T> fromId, Function<T, ResourceLocation> toId) {
            super((JsonPrimitive i) -> fromId.apply(new ResourceLocation(i.getAsString())), (T i) -> new JsonPrimitive(((ResourceLocation)toId.apply(i)).toString()));
        }
    }

    public static class ConfigXDeserializer<T>
    implements JsonDeserializer<T> {
        private final Class<? extends T> tag;
        private final Class<? extends T> reference;

        public ConfigXDeserializer(Class<? extends T> tag, Class<? extends T> reference) {
            this.tag = tag;
            this.reference = reference;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.getAsString().startsWith("#")) {
                return (T)context.deserialize(json, this.tag);
            }
            return (T)context.deserialize(json, this.reference);
        }
    }

    public static class IdentifierBasedSerializer<T>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        protected final Function<ResourceLocation, T> fromId;
        protected final Function<T, ResourceLocation> toId;

        public IdentifierBasedSerializer(Registry<T> registry) {
            this.fromId = i -> registry.m_6612_(i).orElse(null);
            this.toId = arg_0 -> registry.m_7981_(arg_0);
        }

        public IdentifierBasedSerializer(Function<ResourceLocation, T> fromId, Function<T, ResourceLocation> toId) {
            this.fromId = fromId;
            this.toId = toId;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.fromId.apply((ResourceLocation)GSON.fromJson(json, ResourceLocation.class));
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            ResourceLocation id = this.toId.apply(src);
            return IDENTIFIER_SERIALIZER.serialize(id, id.getClass(), context);
        }
    }

    public static class ReferenceSerializer<T extends Reference<?>>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        private final Function<ResourceLocation, T> toReference;

        public ReferenceSerializer(Function<ResourceLocation, T> toReference) {
            this.toReference = toReference;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)((Reference)this.toReference.apply((ResourceLocation)GSON.fromJson(json, ResourceLocation.class)));
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)((Reference)src).getIdentifier());
        }
    }

    public static class SetSerializer<T>
    implements JsonSerializer<Set<T>>,
    JsonDeserializer<Set<T>> {
        private final Function<JsonPrimitive, T> fromJson;
        private final Function<T, JsonPrimitive> toJson;

        public SetSerializer(Function<JsonPrimitive, T> fromJson, Function<T, JsonPrimitive> toJson) {
            this.toJson = toJson;
            this.fromJson = fromJson;
        }

        public JsonElement serialize(Set<T> set, Type type, JsonSerializationContext jsonSerializationContext) {
            return jsonSerializationContext.serialize(set.stream().map(this.toJson).sorted(Comparator.comparing(JsonElement::getAsString)).collect(Collectors.toList()));
        }

        public Set<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Set primitives = (Set)GSON.fromJson(json, new TypeToken<HashSet<JsonPrimitive>>(){}.getType());
            return primitives.stream().map(this.fromJson).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }

    public static class MapDeserializer<K, V>
    implements JsonDeserializer<Map<K, V>> {
        private final Function<ResourceLocation, K> keyFromId;

        public MapDeserializer(Function<ResourceLocation, K> fromId) {
            this.keyFromId = fromId;
        }

        public Map<K, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map identifierVMap = (Map)GSON.fromJson(json, new TypeToken<HashMap<ResourceLocation, V>>(){}.getType());
            HashMap result = new HashMap();
            for (Map.Entry entry : identifierVMap.entrySet()) {
                result.put(this.keyFromId.apply((ResourceLocation)entry.getKey()), entry.getValue());
            }
            return result;
        }
    }
}

