/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config.reference.block;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.reference.block.BlockReference;
import net.flytre.flytre_lib.api.config.reference.block.BlockTagReference;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public interface ConfigBlock {
    public static Set<Block> values(Set<ConfigBlock> blocks, Level world) {
        HashSet<Block> result = new HashSet<Block>();
        for (ConfigBlock block : blocks) {
            if (block instanceof BlockReference) {
                result.add(((BlockReference)block).getValue(world));
                continue;
            }
            Object list = ((BlockTagReference)block).getValue(world);
            if (list == null) continue;
            result.addAll((Collection<Block>)list);
        }
        return result;
    }

    public static boolean contains(Set<ConfigBlock> blocks, Block block, Level world) {
        if (blocks.contains(new BlockReference(block))) {
            return true;
        }
        return blocks.stream().anyMatch(i -> {
            if (!(i instanceof BlockTagReference)) {
                return false;
            }
            Object list = ((BlockTagReference)i).getValue(world);
            return list != null && list.contains(block);
        });
    }

    public static Set<ConfigBlock> of(Set<Block> values) {
        return values.stream().map(BlockReference::new).collect(Collectors.toSet());
    }
}

