/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config.reference.entity;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.reference.entity.EntityReference;
import net.flytre.flytre_lib.api.config.reference.entity.EntityTagReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public interface ConfigEntity {
    public static Set<EntityType<?>> values(Set<ConfigEntity> entities, Level world) {
        HashSet result = new HashSet();
        for (ConfigEntity entity : entities) {
            if (entity instanceof EntityReference) {
                result.add(((EntityReference)entity).getValue(world));
                continue;
            }
            Object list = ((EntityTagReference)entity).getValue(world);
            if (list == null) continue;
            result.addAll((Collection<EntityType<?>>)list);
        }
        return result;
    }

    public static boolean contains(Set<ConfigEntity> entities, EntityType<?> entity, Level world) {
        if (entities.contains(new EntityReference(entity))) {
            return true;
        }
        return entities.stream().anyMatch(i -> {
            if (!(i instanceof EntityTagReference)) {
                return false;
            }
            Object list = ((EntityTagReference)i).getValue(world);
            return list != null && list.contains(entity);
        });
    }

    public static Set<ConfigEntity> of(Set<EntityType<?>> values) {
        return values.stream().map(EntityReference::new).collect(Collectors.toSet());
    }
}

