/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config.reference.fluid;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.reference.fluid.FluidReference;
import net.flytre.flytre_lib.api.config.reference.fluid.FluidTagReference;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public interface ConfigFluid {
    public static Set<Fluid> values(Set<ConfigFluid> fluids, Level world) {
        HashSet<Fluid> result = new HashSet<Fluid>();
        for (ConfigFluid fluid : fluids) {
            if (fluid instanceof FluidReference) {
                result.add(((FluidReference)fluid).getValue(world));
                continue;
            }
            Object list = ((FluidTagReference)fluid).getValue(world);
            if (list == null) continue;
            result.addAll((Collection<Fluid>)list);
        }
        return result;
    }

    public static boolean contains(Set<ConfigFluid> fluids, Fluid fluid, Level world) {
        if (fluids.contains(new FluidReference(fluid))) {
            return true;
        }
        return fluids.stream().anyMatch(i -> {
            if (!(i instanceof FluidTagReference)) {
                return false;
            }
            Object list = ((FluidTagReference)i).getValue(world);
            return list != null && list.contains(fluid);
        });
    }

    public static Set<ConfigFluid> of(Set<Fluid> values) {
        return values.stream().map(FluidReference::new).collect(Collectors.toSet());
    }
}

