/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config.reference.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.reference.item.ItemReference;
import net.flytre.flytre_lib.api.config.reference.item.ItemTagReference;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public interface ConfigItem {
    public static Set<Item> values(Set<ConfigItem> items, Level world) {
        HashSet<Item> result = new HashSet<Item>();
        for (ConfigItem item : items) {
            if (item instanceof ItemReference) {
                result.add(((ItemReference)item).getValue(world));
                continue;
            }
            Object list = ((ItemTagReference)item).getValue(world);
            if (list == null) continue;
            result.addAll((Collection<Item>)list);
        }
        return result;
    }

    public static boolean contains(Set<ConfigItem> items, Item item, Level world) {
        if (items.contains(new ItemReference(item))) {
            return true;
        }
        return items.stream().anyMatch(i -> {
            if (!(i instanceof ItemTagReference)) {
                return false;
            }
            Object list = ((ItemTagReference)i).getValue(world);
            return list != null && list.contains(item);
        });
    }

    public static Set<ConfigItem> of(Set<Item> values) {
        return values.stream().map(ItemReference::new).collect(Collectors.toSet());
    }
}

