/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.flytre.flytre_lib.mixin.gui.EntryListWidgetAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.Nullable;

public class ButtonListWidget<K extends AbstractWidget>
extends ContainerObjectSelectionList<ButtonEntry<K>> {
    protected final int buttonWidth;
    protected final int buttonLeft;
    protected final int buttonPadding;

    public ButtonListWidget(Minecraft client, int parentWidth, int parentHeight, int top, int bottom, int buttonHeight, int buttonPadding, float percentCenter, float percentWidth, float percentBuffer) {
        super(client, parentWidth, parentHeight, top, bottom, buttonHeight + buttonPadding);
        this.buttonWidth = (int)((percentWidth - percentBuffer) * (float)parentWidth);
        this.f_93393_ = (int)((float)parentWidth * (percentCenter - percentWidth / 2.0f));
        this.f_93392_ = this.f_93393_ + (int)(percentWidth * (float)parentWidth);
        this.buttonLeft = (int)((float)parentWidth * percentCenter) - this.buttonWidth / 2;
        this.f_93394_ = false;
        this.buttonPadding = buttonPadding / 2;
    }

    public void addEntry(Option option) {
        this.m_7085_((AbstractSelectionList.Entry)ButtonEntry.create(this.f_93386_.f_91066_, this.buttonLeft, this.buttonWidth, option, this.buttonPadding));
    }

    public void addEntry(ButtonCreator<K> buttonCreator) {
        this.m_7085_((AbstractSelectionList.Entry)ButtonEntry.create(this.buttonLeft, this.buttonWidth, buttonCreator, this.buttonPadding));
    }

    public int m_5759_() {
        return this.f_93392_ - this.f_93393_;
    }

    protected int m_5756_() {
        return super.m_5756_() + 32;
    }

    @Nullable
    public K getButtonFor(Option option) {
        for (ButtonEntry element : this.m_6702_()) {
            if (element.option != option || option == null) continue;
            return element.button;
        }
        return null;
    }

    public Optional<K> getHoveredButton(double mouseX, double mouseY) {
        for (ButtonEntry entry : this.m_6702_()) {
            if (!entry.button.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(entry.button);
        }
        return Optional.empty();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.m_93481_(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        ButtonEntry<K> entry = this.getEntryAtPosition2(mouseX, mouseY);
        if (entry != null) {
            if (entry.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)entry);
                this.m_7897_(true);
                return true;
            }
        } else if (button == 0) {
            this.m_6205_((int)(mouseX - (double)(this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2)), (int)(mouseY - (double)this.f_93390_) + (int)this.m_93517_() - 4);
            return true;
        }
        return ((EntryListWidgetAccessor)((Object)this)).getScrolling();
    }

    protected final ButtonEntry<K> getEntryAtPosition2(double x, double y) {
        for (ButtonEntry entry : this.m_6702_()) {
            if (!entry.button.m_5953_(x, y)) continue;
            return entry;
        }
        return null;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int k = this.m_5747_();
        if (this.m_93517_() > (double)this.m_93518_()) {
            this.m_93410_(this.m_93518_());
        }
        int l = this.f_93390_ + 4 - (int)this.m_93517_();
        this.m_93451_(matrices, k, l, mouseX, mouseY, delta);
    }

    protected static class ButtonEntry<K extends AbstractWidget>
    extends ContainerObjectSelectionList.Entry<ButtonEntry<K>> {
        public final K button;
        public final Option option;
        public final int padding;

        protected ButtonEntry(K button, int padding) {
            this.button = button;
            this.option = null;
            this.padding = padding;
        }

        protected ButtonEntry(K button, Option option, int padding) {
            this.button = button;
            this.option = option;
            this.padding = padding;
        }

        public static <K extends AbstractWidget> ButtonEntry<K> create(Options options, int startX, int buttonWidth, Option option, int buttonPadding) {
            return new ButtonEntry<AbstractWidget>(option.m_7496_(options, startX, 0, buttonWidth), option, buttonPadding);
        }

        public static <K extends AbstractWidget> ButtonEntry<K> create(int startX, int buttonWidth, ButtonCreator<K> buttonCreator, int buttonPadding) {
            K button = buttonCreator.create(startX, 0, buttonWidth);
            return new ButtonEntry<K>(button, buttonPadding);
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ((AbstractWidget)this.button).f_93621_ = y + this.padding;
            this.button.m_6305_(matrices, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.button);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.singletonList(this.button);
        }
    }

    @FunctionalInterface
    public static interface ButtonCreator<K extends AbstractWidget> {
        public K create(int var1, int var2, int var3);
    }
}

