/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.button;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TranslucentCyclingButtonWidget<T>
extends AbstractButton
implements TooltipAccessor {
    static final BooleanSupplier HAS_ALT_DOWN = Screen::m_96639_;
    private static final List<Boolean> BOOLEAN_VALUES = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component optionText;
    private final Values<T> values;
    private final Function<T, Component> valueToText;
    private final Function<TranslucentCyclingButtonWidget<T>, MutableComponent> narrationMessageFactory;
    private final UpdateCallback<T> callback;
    private final TooltipFactory<T> tooltipFactory;
    private final boolean optionTextOmitted;
    private int index;
    private T value;
    @Nullable
    private BiFunction<T, Boolean, Integer> valueHoveredToColor;

    TranslucentCyclingButtonWidget(int x, int y, int width, int height, Component message, Component optionText, int index, T value, Values<T> values, Function<T, Component> valueToText, Function<TranslucentCyclingButtonWidget<T>, MutableComponent> narrationMessageFactory, UpdateCallback<T> callback, TooltipFactory<T> tooltipFactory, boolean optionTextOmitted) {
        super(x, y, width, height, message);
        this.optionText = optionText;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueToText = valueToText;
        this.narrationMessageFactory = narrationMessageFactory;
        this.callback = callback;
        this.tooltipFactory = tooltipFactory;
        this.optionTextOmitted = optionTextOmitted;
        this.valueHoveredToColor = (val, hovered) -> RenderUtils.getModernUiColor(true, hovered);
    }

    public static <T> Builder<T> builder(Function<T, Component> valueToText) {
        return new Builder<T>(valueToText);
    }

    public static Builder<Boolean> onOffBuilder(Component on, Component off) {
        return new Builder<Boolean>(value -> value != false ? on : off).values(BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(value -> value != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_).values(BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder(boolean initialValue) {
        return TranslucentCyclingButtonWidget.onOffBuilder().initially(initialValue);
    }

    public void setValueHoveredToColor(@Nullable BiFunction<T, Boolean, Integer> valueHoveredToColor) {
        this.valueHoveredToColor = valueHoveredToColor;
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycle(-1);
        } else {
            this.cycle(1);
        }
    }

    private void cycle(int amount) {
        List<T> list = this.values.getCurrent();
        this.index = Mth.m_14100_((int)(this.index + amount), (int)list.size());
        T object = list.get(this.index);
        this.internalSetValue(object);
        this.callback.onValueChange(this, object);
    }

    private T getValue(int offset) {
        List<T> list = this.values.getCurrent();
        return list.get(Mth.m_14100_((int)(this.index + offset), (int)list.size()));
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.cycle(-1);
        } else if (amount < 0.0) {
            this.cycle(1);
        }
        return true;
    }

    private void internalSetValue(T value) {
        Component text = this.composeText(value);
        this.m_93666_(text);
        this.value = value;
    }

    private Component composeText(T value) {
        return this.optionTextOmitted ? this.valueToText.apply(value) : this.composeGenericOptionText(value);
    }

    private MutableComponent composeGenericOptionText(T value) {
        return CommonComponents.m_178393_((Component)this.optionText, (Component)this.valueToText.apply(value));
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        List<T> list = this.values.getCurrent();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.internalSetValue(value);
    }

    protected MutableComponent m_5646_() {
        return this.narrationMessageFactory.apply(this);
    }

    public void m_142291_(NarrationElementOutput builder) {
        builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T object = this.getValue(1);
            Component text = this.composeText(object);
            if (this.m_93696_()) {
                builder.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.cycle_button.usage.focused", new Object[]{text}));
            } else {
                builder.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.cycle_button.usage.hovered", new Object[]{text}));
            }
        }
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            Minecraft client = Minecraft.m_91087_();
            int color = this.f_93623_ ? this.valueHoveredToColor.apply(this.value, this.m_198029_()) : RenderUtils.getModernUiColor(false, false);
            RenderUtils.drawRect(this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, color);
            TranslucentCyclingButtonWidget.m_93215_((PoseStack)matrixStack, (Font)client.f_91062_, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)0xFFFFFF);
        }
    }

    public MutableComponent getGenericNarrationMessage() {
        return TranslucentCyclingButtonWidget.m_168799_((Component)(this.optionTextOmitted ? this.composeGenericOptionText(this.value) : this.m_6035_()));
    }

    public List<FormattedCharSequence> m_141932_() {
        return (List)this.tooltipFactory.apply(this.value);
    }

    private static interface Values<T> {
        public static <T> Values<T> of(List<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new Values<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getCurrent() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }

        public static <T> Values<T> of(final BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            ImmutableList list = ImmutableList.copyOf(defaults);
            ImmutableList list2 = ImmutableList.copyOf(alternatives);
            return new Values<T>((List)list2, (List)list){
                final /* synthetic */ List val$list2;
                final /* synthetic */ List val$list;
                {
                    this.val$list2 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getCurrent() {
                    return alternativeToggle.getAsBoolean() ? this.val$list2 : this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }

        public List<T> getCurrent();

        public List<T> getDefaults();
    }

    public static interface UpdateCallback<T> {
        public void onValueChange(TranslucentCyclingButtonWidget<T> var1, T var2);
    }

    @FunctionalInterface
    public static interface TooltipFactory<T>
    extends Function<T, List<FormattedCharSequence>> {
    }

    public static class Builder<T> {
        private final Function<T, Component> valueToText;
        private int initialIndex;
        @Nullable
        private T value;
        private TooltipFactory<T> tooltipFactory = value -> ImmutableList.of();
        private Function<TranslucentCyclingButtonWidget<T>, MutableComponent> narrationMessageFactory = TranslucentCyclingButtonWidget::getGenericNarrationMessage;
        private Values<T> values = Values.of(ImmutableList.of());
        private boolean optionTextOmitted;

        public Builder(Function<T, Component> valueToText) {
            this.valueToText = valueToText;
        }

        public Builder<T> values(List<T> values) {
            this.values = Values.of(values);
            return this;
        }

        @SafeVarargs
        public final Builder<T> values(T ... values) {
            return this.values((List<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> values(List<T> defaults, List<T> alternatives) {
            this.values = Values.of(HAS_ALT_DOWN, defaults, alternatives);
            return this;
        }

        public Builder<T> values(BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            this.values = Values.of(alternativeToggle, defaults, alternatives);
            return this;
        }

        public Builder<T> tooltip(TooltipFactory<T> tooltipFactory) {
            this.tooltipFactory = tooltipFactory;
            return this;
        }

        public Builder<T> initially(T value) {
            this.value = value;
            int i = this.values.getDefaults().indexOf(value);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> narration(Function<TranslucentCyclingButtonWidget<T>, MutableComponent> narrationMessageFactory) {
            this.narrationMessageFactory = narrationMessageFactory;
            return this;
        }

        public Builder<T> omitKeyText() {
            this.optionTextOmitted = true;
            return this;
        }

        public TranslucentCyclingButtonWidget<T> build(int x, int y, int width, int height, Component optionText) {
            return this.build(x, y, width, height, optionText, (button, value) -> {});
        }

        public TranslucentCyclingButtonWidget<T> build(int x, int y, int width, int height, Component optionText, UpdateCallback<T> callback) {
            List<T> list = this.values.getDefaults();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.value != null ? this.value : list.get(this.initialIndex);
            Component text = this.valueToText.apply(object);
            Component text2 = this.optionTextOmitted ? text : CommonComponents.m_178393_((Component)optionText, (Component)text);
            return new TranslucentCyclingButtonWidget<T>(x, y, width, height, text2, optionText, this.initialIndex, object, this.values, this.valueToText, this.narrationMessageFactory, callback, this.tooltipFactory, this.optionTextOmitted);
        }
    }
}

