/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.button;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.flytre.flytre_lib.api.gui.button.TranslucentCyclingButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TranslucentCyclingOption<T>
extends Option {
    private final Setter<T> setter;
    private final Function<Options, T> getter;
    private final Supplier<TranslucentCyclingButtonWidget.Builder<T>> buttonBuilderFactory;
    private Function<Minecraft, TranslucentCyclingButtonWidget.TooltipFactory<T>> tooltips = client -> value -> ImmutableList.of();

    private TranslucentCyclingOption(String key, Function<Options, T> getter, Setter<T> setter, Supplier<TranslucentCyclingButtonWidget.Builder<T>> buttonBuilderFactory) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.buttonBuilderFactory = buttonBuilderFactory;
    }

    public static <T> TranslucentCyclingOption<T> create(String key, List<T> values, Function<T, Component> valueToText, Function<Options, T> getter, Setter<T> setter) {
        return new TranslucentCyclingOption<T>(key, getter, setter, () -> TranslucentCyclingButtonWidget.builder(valueToText).values(values));
    }

    public static <T> TranslucentCyclingOption<T> create(String key, Supplier<List<T>> valuesSupplier, Function<T, Component> valueToText, Function<Options, T> getter, Setter<T> setter) {
        return new TranslucentCyclingOption<T>(key, getter, setter, () -> TranslucentCyclingButtonWidget.builder(valueToText).values((List)valuesSupplier.get()));
    }

    public static <T> TranslucentCyclingOption<T> create(String key, List<T> defaults, List<T> alternatives, BooleanSupplier alternativeToggle, Function<T, Component> valueToText, Function<Options, T> getter, Setter<T> setter) {
        return new TranslucentCyclingOption<T>(key, getter, setter, () -> TranslucentCyclingButtonWidget.builder(valueToText).values(alternativeToggle, defaults, alternatives));
    }

    public static <T> TranslucentCyclingOption<T> create(String key, T[] values, Function<T, Component> valueToText, Function<Options, T> getter, Setter<T> setter) {
        return new TranslucentCyclingOption<T>(key, getter, setter, () -> TranslucentCyclingButtonWidget.builder(valueToText).values(values));
    }

    public static TranslucentCyclingOption<Boolean> create(String key, Component on, Component off, Function<Options, Boolean> getter, Setter<Boolean> setter) {
        return new TranslucentCyclingOption<Boolean>(key, getter, setter, () -> TranslucentCyclingButtonWidget.onOffBuilder(on, off));
    }

    public static TranslucentCyclingOption<Boolean> create(String key, Function<Options, Boolean> getter, Setter<Boolean> setter) {
        return new TranslucentCyclingOption<Boolean>(key, getter, setter, TranslucentCyclingButtonWidget::onOffBuilder);
    }

    public static TranslucentCyclingOption<Boolean> create(String key, Component tooltip, Function<Options, Boolean> getter, Setter<Boolean> setter) {
        return TranslucentCyclingOption.create(key, getter, setter).tooltip(client -> {
            List list = client.f_91062_.m_92923_((FormattedText)tooltip, 200);
            return value -> list;
        });
    }

    public TranslucentCyclingOption<T> tooltip(Function<Minecraft, TranslucentCyclingButtonWidget.TooltipFactory<T>> tooltips) {
        this.tooltips = tooltips;
        return this;
    }

    public AbstractWidget m_7496_(Options options, int x, int y, int width) {
        TranslucentCyclingButtonWidget.TooltipFactory<T> tooltipFactory = this.tooltips.apply(Minecraft.m_91087_());
        return this.buttonBuilderFactory.get().tooltip(tooltipFactory).initially(this.getter.apply(options)).build(x, y, width, 20, this.m_91714_(), (button, value) -> {
            this.setter.accept(options, this, value);
            options.m_92169_();
        });
    }

    @FunctionalInterface
    public static interface Setter<T> {
        public void accept(Options var1, Option var2, T var3);
    }
}

