/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.text_field;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.base.util.FakeWorld;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.flytre.flytre_lib.api.gui.text_field.DropdownMenu;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.flytre.flytre_lib.impl.base.RenderUtilsImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public final class DropdownUtils {
    public static final Pattern IDENTIFIER_REGEX = Pattern.compile("^([a-z0-9_.-]+:)?[a-z0-9_.-/]+$", 2);

    private DropdownUtils() {
    }

    public static DropdownMenu createItemDropdown() {
        return DropdownUtils.createItemDropdown(0, 0);
    }

    public static DropdownMenu createItemDropdown(int xLoc, int yLoc) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        DropdownMenu searchField = new DropdownMenu(xLoc, yLoc, Math.min(250, width), 20, (Component)new TranslatableComponent("null"), Registry.f_122827_.m_6566_().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        searchField.setRenderer(DropdownUtils.identifierRenderer(Registry.f_122827_, (ResourceLocation i) -> ((Item)Registry.f_122827_.m_7745_(i)).m_7968_()));
        searchField.setMatcher(DropdownUtils::identifierMatch);
        searchField.setTextXOffset(25);
        searchField.setOptionRenderer(DropdownUtils::registryRenderer);
        searchField.setEntryWidth(200);
        return searchField;
    }

    public static DropdownMenu createBlockDropdown() {
        return DropdownUtils.createBlockDropdown(0, 0);
    }

    public static DropdownMenu createBlockDropdown(int xLoc, int yLoc) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        DropdownMenu searchField = new DropdownMenu(xLoc, yLoc, Math.min(250, width), 20, (Component)new TranslatableComponent("null"), Registry.f_122824_.m_6566_().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        searchField.setRenderer(DropdownUtils.identifierRenderer(Registry.f_122824_, (ResourceLocation i) -> ((Block)Registry.f_122824_.m_7745_(i)).m_5456_().m_7968_()));
        searchField.setMatcher(DropdownUtils::identifierMatch);
        searchField.setTextXOffset(25);
        searchField.setOptionRenderer(DropdownUtils::registryRenderer);
        searchField.setEntryWidth(200);
        return searchField;
    }

    public static DropdownMenu createGenericDropdown(List<String> entries) {
        return DropdownUtils.createGenericDropdown(0, 0, entries);
    }

    public static DropdownMenu createGenericDropdown(int xLoc, int yLoc, List<String> entries) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        DropdownMenu searchField = new DropdownMenu(xLoc, yLoc, Math.min(250, width), 20, (Component)new TranslatableComponent("null"), entries);
        searchField.setEntryWidth(200);
        return searchField;
    }

    public static DropdownMenu createEntityDropdown() {
        return DropdownUtils.createEntityDropdown(0, 0);
    }

    public static DropdownMenu createEntityDropdown(int xLoc, int yLoc) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        HashMap<EntityType, Entity> entityMap = new HashMap<EntityType, Entity>();
        for (ResourceLocation id : Registry.f_122826_.m_6566_()) {
            EntityType type = (EntityType)Registry.f_122826_.m_7745_(id);
            entityMap.put(type, type.m_20615_((Level)FakeWorld.getInstance()));
        }
        DropdownMenu searchField = new DropdownMenu(xLoc, yLoc, Math.min(250, width), 20, (Component)new TranslatableComponent("null"), Registry.f_122826_.m_6566_().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        searchField.setRenderer(DropdownUtils.identifierRenderer(Registry.f_122826_, (Font textRenderer, PoseStack matrices, String text, String fullText, float x, float y, int color, boolean cursor) -> {
            block5: {
                boolean valid = DropdownUtils.identifierPredicate(fullText, Registry.f_122826_);
                if (valid) {
                    EntityType type = (EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)fullText));
                    Entity entity = (Entity)entityMap.get(type);
                    try {
                        if (entityMap.containsKey(type)) {
                            RenderUtils.renderSpinningEntity((int)x - 15, (int)y + 10, 8, 0.0f, 0.0f, entity);
                            break block5;
                        }
                        DropdownUtils.drawQuestionMark(matrices, (int)x - 25, (int)y - 4);
                    }
                    catch (Exception e) {
                        entityMap.remove(type);
                        DropdownUtils.drawQuestionMark(matrices, (int)x - 25, (int)y - 4);
                    }
                } else {
                    DropdownUtils.drawQuestionMark(matrices, (int)x - 25, (int)y - 4);
                }
            }
            return 0;
        }));
        searchField.setMatcher(DropdownUtils::identifierMatch);
        searchField.setTextXOffset(25);
        searchField.setOptionRenderer(DropdownUtils::registryRenderer);
        searchField.setEntryWidth(200);
        return searchField;
    }

    public static DropdownMenu createFluidDropdown() {
        return DropdownUtils.createFluidDropdown(0, 0);
    }

    public static DropdownMenu createFluidDropdown(int xLoc, int yLoc) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        DropdownMenu searchField = new DropdownMenu(xLoc, yLoc, Math.min(250, width), 20, (Component)new TranslatableComponent("null"), Registry.f_122822_.m_6566_().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        if (RenderUtilsImpl.isFluidRenderingSupported()) {
            searchField.setRenderer(DropdownUtils.identifierRenderer(Registry.f_122822_, (Font textRenderer, PoseStack matrices, String text, String fullText, float x, float y, int color, boolean cursor) -> {
                boolean valid = DropdownUtils.identifierPredicate(fullText, Registry.f_122822_);
                if (valid) {
                    Fluid fluid = (Fluid)Registry.f_122822_.m_7745_(ResourceLocation.m_135820_((String)fullText));
                    RenderUtils.renderFluidInGui(matrices, fluid, 16, (int)(x - 25.0f), (int)(y - 4.0f), 16, 16);
                } else {
                    DropdownUtils.drawQuestionMark(matrices, (int)x - 25, (int)y - 4);
                }
                return 0;
            }));
            searchField.setTextXOffset(25);
        }
        searchField.setMatcher(DropdownUtils::identifierMatch);
        searchField.setOptionRenderer(DropdownUtils::registryRenderer);
        searchField.setEntryWidth(200);
        return searchField;
    }

    public static void drawQuestionMark(PoseStack matrices, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("flytre_lib:textures/gui/config/question_mark.png"));
        GuiComponent.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
    }

    public static boolean identifierMatch(String option, String text) {
        return text.length() > 1 && option.contains(text) && !option.equals(text);
    }

    public static String defaultRenderer(String option, String text, Font textRenderer, TranslucentTextField.TextFieldRenderer textFieldRenderer, int entryWidth, int entryHeight, int textXOffset) {
        int xScrollInner = text.length();
        int len = textRenderer.m_92834_(option, entryWidth - textXOffset).length();
        String str = len < option.length() ? textRenderer.m_92834_("-" + option.substring(xScrollInner), entryWidth - textXOffset) : textRenderer.m_92834_(option, entryWidth - textXOffset);
        return str;
    }

    public static String registryRenderer(String option, String text, Font textRenderer, TranslucentTextField.TextFieldRenderer textFieldRenderer, int entryWidth, int entryHeight, int textXOffset) {
        if (option.startsWith("minecraft:") && !text.startsWith("minecraft:")) {
            option = option.replace("minecraft:", "");
        }
        return DropdownUtils.defaultRenderer(option, text, textRenderer, textFieldRenderer, entryWidth, entryHeight, textXOffset);
    }

    public static boolean identifierPredicate(String str, Registry<?> registry) {
        try {
            ResourceLocation id = str.startsWith("#") ? ResourceLocation.m_135820_((String)str.substring(1)) : ResourceLocation.m_135820_((String)str);
            return registry.m_7804_(id);
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public static TranslucentTextField.TextFieldRenderer identifierRenderer(Registry<?> registry, TranslucentTextField.TextFieldRenderer customRenderer) {
        return (textRenderer, matrices, text, fullText, x, y, color, cursor) -> {
            boolean tag;
            boolean valid = DropdownUtils.identifierPredicate(fullText, registry);
            boolean bl = tag = fullText.startsWith("#") && IDENTIFIER_REGEX.matcher(fullText.substring(1)).find();
            FormattedCharSequence ordered = tag ? FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_.m_131148_(TextColor.m_131266_((int)-12417035))) : (valid ? FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))) : FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            if (!cursor) {
                customRenderer.render(textRenderer, matrices, text, fullText, x, y, color, false);
            }
            return textRenderer.m_92744_(matrices, ordered, x, y, color);
        };
    }

    public static int identifierTextFieldRenderer(Font renderer, PoseStack matrices, String text, String fullText, float x, float y, int color, boolean cursor) {
        boolean valid = IDENTIFIER_REGEX.matcher(fullText).find();
        return renderer.m_92744_(matrices, FormattedCharSequence.m_13714_((String)text, (Style)(valid ? Style.f_131099_ : Style.f_131099_.m_131140_(ChatFormatting.RED))), x, y, color);
    }

    public static TranslucentTextField.TextFieldRenderer identifierRenderer(Registry<?> registry, Function<ResourceLocation, ItemStack> icon) {
        TranslucentTextField.TextFieldRenderer customRenderer = (textRenderer, matrices, text, fullText, x, y, color, cursor) -> {
            boolean valid = DropdownUtils.identifierPredicate(fullText, registry);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            if (valid) {
                itemRenderer.m_115123_((ItemStack)icon.apply(ResourceLocation.m_135820_((String)fullText)), (int)x - 25, (int)y - 4);
            } else {
                DropdownUtils.drawQuestionMark(matrices, (int)x - 25, (int)y - 4);
            }
            return 0;
        };
        return DropdownUtils.identifierRenderer(registry, customRenderer);
    }
}

