/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.inventory;

import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import net.flytre.flytre_lib.api.base.util.InventoryUtils;
import net.flytre.flytre_lib.api.storage.inventory.IOType;
import net.flytre.flytre_lib.api.storage.inventory.IOTypeProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface EasyInventory
extends WorldlyContainer,
IOTypeProvider {
    public NonNullList<ItemStack> getItems();

    public Map<Direction, IOType> getItemIO();

    @Override
    default public Map<Direction, IOType> getIOType() {
        return this.getItemIO();
    }

    default public int m_6643_() {
        return this.getItems().size();
    }

    default public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.m_6596_();
        }
        return result;
    }

    default public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.getItems(), (int)slot);
        this.m_6596_();
        return stack;
    }

    default public void m_6836_(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    default public boolean m_6542_(Player player) {
        return true;
    }

    default public void m_6211_() {
        this.getItems().clear();
    }

    default public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    default public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack) && this.getItemIO().get(dir).canInsert();
    }

    default public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return this.getItemIO().get(dir).canExtract();
    }

    default public ItemStack addStack(ItemStack stack, Direction dir) {
        return this.customAddStack(stack, this.m_7071_(dir), (i, stk) -> this.m_7157_((int)i, (ItemStack)stk, dir));
    }

    default public ItemStack addStackInternal(ItemStack stack) {
        return this.customAddStack(stack, IntStream.range(0, this.m_6643_()).toArray(), (arg_0, arg_1) -> ((EasyInventory)this).m_7013_(arg_0, arg_1));
    }

    default public ItemStack customAddStack(ItemStack stack, int[] slots, BiPredicate<Integer, ItemStack> condition) {
        int i;
        int[] nArray = slots;
        int n = nArray.length;
        for (int j = 0; j < n && !(stack = InventoryUtils.mergeStackIntoSlot(stack, (Container)this, i = nArray[j])).m_41619_(); ++j) {
        }
        return stack;
    }

    default public void m_5856_(Player player) {
        super.m_5856_(player);
    }

    default public void m_5785_(Player player) {
        super.m_5785_(player);
    }
}

