/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.inventory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;

public enum IOType {
    INPUT(1, true, false),
    OUTPUT(0, false, true),
    BOTH(2, true, true),
    NEITHER(3, false, false);

    private final int index;
    private final boolean insert;
    private final boolean extract;

    private IOType(int i, boolean insert, boolean extract) {
        this.index = i;
        this.insert = insert;
        this.extract = extract;
    }

    public static IOType byId(int id) {
        for (IOType type : IOType.values()) {
            if (type.index != id) continue;
            return type;
        }
        throw new AssertionError((Object)"Invalid id");
    }

    public static Map<Direction, IOType> intToMap(int n) {
        int[] array = IOType.fromInt(n, 6);
        HashMap<Direction, IOType> result = new HashMap<Direction, IOType>();
        result.put(Direction.NORTH, IOType.byId(array[0]));
        result.put(Direction.WEST, IOType.byId(array[1]));
        result.put(Direction.EAST, IOType.byId(array[2]));
        result.put(Direction.UP, IOType.byId(array[3]));
        result.put(Direction.DOWN, IOType.byId(array[4]));
        result.put(Direction.SOUTH, IOType.byId(array[5]));
        return result;
    }

    public static int mapToInt(Map<Direction, IOType> map) {
        int[] array = new int[]{map.get((Object)Direction.NORTH).index, map.get((Object)Direction.WEST).index, map.get((Object)Direction.EAST).index, map.get((Object)Direction.UP).index, map.get((Object)Direction.DOWN).index, map.get((Object)Direction.SOUTH).index};
        return IOType.toInt(array);
    }

    public static int toInt(int[] arr) {
        int n = 0;
        int i = -1;
        while (i < arr.length - 1) {
            n = (int)((double)n + (double)arr[++i] * Math.pow(IOType.values().length, i));
        }
        return n;
    }

    public static int[] fromInt(int n, int size) {
        int[] result = new int[size];
        int i = size - 1;
        int c = (int)Math.pow(IOType.values().length, i);
        while (i-- >= 0) {
            result[i + 1] = c > 0 ? n / c : 0;
            n %= c;
            c /= IOType.values().length;
        }
        return result;
    }

    public boolean canInsert() {
        return this.insert;
    }

    public boolean canExtract() {
        return this.extract;
    }

    public int getIndex() {
        return this.index;
    }
}

