/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.inventory.filter;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.flytre.flytre_lib.api.gui.CoordinateProvider;
import net.flytre.flytre_lib.api.gui.button.ToggleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements CoordinateProvider {
    protected static final ResourceLocation MODE_BUTTON = new ResourceLocation("flytre_lib:textures/gui/button/check_ex.png");
    protected static final ResourceLocation MOD_BUTTON = new ResourceLocation("flytre_lib:textures/gui/button/mod.png");
    protected static final ResourceLocation NBT_BUTTON = new ResourceLocation("flytre_lib:textures/gui/button/nbt.png");

    public FilteredScreen(T handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    protected void sendPacket(ToggleButton button, BiFunction<BlockPos, Integer, ? extends Packet<ServerGamePacketListener>> packetMaker, @Nullable BlockPos pos) {
        button.toggleState();
        Packet<ServerGamePacketListener> packet = packetMaker.apply(pos, button.getState());
        assert (this.f_96541_ != null);
        Objects.requireNonNull(this.f_96541_.m_91403_()).m_104955_(packet);
    }

    protected void addButton(int startFrame, int index, ResourceLocation texture, BiFunction<BlockPos, Integer, ? extends Packet<ServerGamePacketListener>> packetMaker, Supplier<BlockPos> posGetter, Component tooltip1, Component tooltip2) {
        ToggleButton button = new ToggleButton(this.f_97735_ + 177, this.f_96544_ / 2 - 80 + 20 * index, 16, 16, startFrame, texture, buttonWidget -> this.sendPacket((ToggleButton)buttonWidget, packetMaker, (BlockPos)posGetter.get()), "");
        button.setTooltips(tooltip1, tooltip2);
        button.setTooltipRenderer((arg_0, arg_1, arg_2, arg_3) -> ((FilteredScreen)this).m_96597_(arg_0, arg_1, arg_2, arg_3));
        this.m_142416_((GuiEventListener)button);
    }

    @Override
    public int getX() {
        return this.f_97735_;
    }

    @Override
    public int getY() {
        return this.f_97736_;
    }
}

