/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.base.util.InventoryUtils;
import net.flytre.flytre_lib.api.storage.recipe.OutputProvider;
import net.flytre.flytre_lib.api.storage.recipe.QuantifiedIngredient;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class RecipeUtils {
    private static final Map<Item, List<CraftingRecipe>> CACHE = new HashMap<Item, List<CraftingRecipe>>();
    private static final Queue<Item> CACHE_HANDLER = new LinkedList<Item>();

    private RecipeUtils() {
        throw new AssertionError();
    }

    private static boolean nullCheck(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            return true;
        }
        if (json.has("item")) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
            return !Registry.f_122827_.m_6566_().contains(id);
        }
        if (json.has("tag")) {
            ResourceLocation identifier2 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            try {
                HolderSet.Named messy = (HolderSet.Named)Registry.f_122827_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)identifier2)).orElseThrow(() -> new JsonSyntaxException("Unknown item tag '" + identifier2 + "'"));
                return messy != null;
            }
            catch (JsonSyntaxException e) {
                return true;
            }
        }
        return true;
    }

    public static void craftOutput(Container inv, int lower, int upper, OutputProvider[] providers) {
        HashSet<Integer> checked = new HashSet<Integer>();
        block0: for (OutputProvider output : providers) {
            int i;
            boolean matched = false;
            for (i = lower; i < upper; ++i) {
                if (checked.contains(i) || !InventoryUtils.canUnifyStacks(output.getStack(), inv.m_8020_(i))) continue;
                matched = true;
                checked.add(i);
                inv.m_8020_(i).m_41769_(output.getStack().m_41613_());
                break;
            }
            if (matched) continue;
            for (i = lower; i < upper; ++i) {
                if (!inv.m_8020_(i).m_41619_()) continue;
                inv.m_6836_(i, output.getStack());
                continue block0;
            }
        }
    }

    public static boolean matches(Container inv, int lower, int upper, OutputProvider[] outputProviders) {
        int blanks = 0;
        for (int i = lower; i < upper; ++i) {
            if (!inv.m_8020_(i).m_41619_()) continue;
            ++blanks;
        }
        HashSet<Integer> checked = new HashSet<Integer>();
        for (OutputProvider output : outputProviders) {
            boolean matched = false;
            for (int i = lower; i < upper; ++i) {
                if (checked.contains(i) || !InventoryUtils.canUnifyStacks(output.getStack(), inv.m_8020_(i))) continue;
                matched = true;
                checked.add(i);
                break;
            }
            if (matched) continue;
            if (blanks == 0) {
                return false;
            }
            --blanks;
        }
        return true;
    }

    public static boolean craftingInputMatch(CraftingRecipe recipe, Container inv, int lower, int upper) {
        NonNullList ingredients = recipe.m_7527_();
        List<Ingredient> nonEmptyIngredients = ingredients.stream().filter(i -> !i.m_43947_()).toList();
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
        for (int i2 = lower; i2 < upper; ++i2) {
            copy.add(i2, inv.m_8020_(i2).m_41777_());
        }
        for (Ingredient ingredient : nonEmptyIngredients) {
            boolean matched = false;
            for (int i3 = lower; i3 < upper; ++i3) {
                if (!ingredient.test((ItemStack)copy.get(i3))) continue;
                matched = true;
                ((ItemStack)copy.get(i3)).m_41774_(1);
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static void actuallyCraft(CraftingRecipe recipe, Container inv, int lower, int upper) {
        NonNullList ingredients = recipe.m_7527_();
        List<Ingredient> actual = ingredients.stream().filter(i -> !i.m_43947_()).toList();
        block0: for (Ingredient ingredient : actual) {
            for (int i2 = lower; i2 < upper; ++i2) {
                if (!ingredient.test(inv.m_8020_(i2))) continue;
                ItemStack stack = inv.m_8020_(i2);
                if (stack.m_41613_() == 1 && stack.m_41720_().m_41470_()) {
                    inv.m_6836_(i2, new ItemStack((ItemLike)stack.m_41720_().m_41469_(), 1));
                    continue block0;
                }
                stack.m_41774_(1);
                continue block0;
            }
        }
    }

    public static List<CraftingRecipe> craftingRecipesWithOutput(Item item, Level world) {
        if (CACHE.containsKey(item)) {
            return CACHE.get(item);
        }
        List<CraftingRecipe> recipes = world.m_7465_().m_44013_(RecipeType.f_44107_).stream().filter(i -> !(i instanceof CustomRecipe)).filter(i -> i.m_8043_().m_41720_() == item).collect(Collectors.toList());
        CACHE.put(item, recipes);
        CACHE_HANDLER.add(item);
        if (CACHE.size() > 10) {
            CACHE.remove(CACHE_HANDLER.poll());
        }
        return recipes;
    }

    @Nullable
    public static CraftingRecipe getFirstCraftingMatch(Item item, Container inv, Level world, int lower, int upper) {
        List<CraftingRecipe> outputs = RecipeUtils.craftingRecipesWithOutput(item, world);
        Optional<CraftingRecipe> result = outputs.stream().filter(i -> RecipeUtils.craftingInputMatch(i, inv, lower, upper)).findFirst();
        return result.orElse(null);
    }

    public static OutputProvider[] getOutputProviders(JsonObject json, String pluralKey, String singularKey) {
        OutputProvider[] result;
        if (GsonHelper.m_13885_((JsonObject)json, (String)pluralKey)) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)pluralKey);
            result = new OutputProvider[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                result[i] = OutputProvider.fromJson(array.get(i));
            }
        } else {
            result = new OutputProvider[]{OutputProvider.fromJson(json.get(singularKey))};
        }
        return result;
    }

    public static QuantifiedIngredient[] getQuantifiedIngredients(JsonObject json, String pluralKey, String singularKey) {
        return RecipeUtils.getQuantifiedIngredients(json, pluralKey, singularKey, false);
    }

    public static QuantifiedIngredient[] getQuantifiedIngredients(JsonObject json, String pluralKey, String singularKey, boolean opt) {
        QuantifiedIngredient[] ingredients = new QuantifiedIngredient[]{};
        if (GsonHelper.m_13885_((JsonObject)json, (String)pluralKey)) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)pluralKey);
            ingredients = new QuantifiedIngredient[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                ingredients[i] = QuantifiedIngredient.fromJson(array.get(i));
            }
        } else if (GsonHelper.m_13900_((JsonObject)json, (String)singularKey) || !opt) {
            ingredients = new QuantifiedIngredient[]{QuantifiedIngredient.fromJson(json.get(singularKey))};
        }
        return ingredients;
    }
}

